
(define-module (embedded-dev build-system crosstool-ng)
  #:export (%crosstool-ng-build-system-modules
            crosstool-ng-build
            crosstool-ng-build-system))

(define (default-crosstool-ng )
  "Return the default crosstool-ng package"
  (let ((crosstool-ng (resolve-interface '(embedded-dev packages crosstool-ng))))
    (module-ref crosstool-ng 'crosstool-ng)))

;; Lower package to bag

(define* (lower name
                #:key source inputs native-inputs outputs system target
                (crosstool-ng (default-crosstool-ng))
                #:allow-other-keys
                #:rest arguments
                )
  "Return a bag for NAME"
  (define private-keywords
    '(#:target #:ct-ng #:inputs #:native-inputs))

  (bag
    (name name)
    (system system)
    (host-inputs `(,@(if source
                        `(("source" ,source))
                        '())
                  ,@inputs
                  ,@(standard-packages)))
    (build-inputs `(("crosstool-ng" ,crosstool-ng)
                    ,@native-inputs))
    (outputs outputs)
    (build crosstool-ng-build)
    (arguments arguments)))

;; Lower bag to derivation
(define* (crosstool-ng-build name inputs
                             ;; TODO: Make sample calculated
                             ;;        get current arch and add to $arch-unknown-linux-gnu
                             #:key (sample "unknown")
                             (test-target "test")
                             (tests? #t)
                             (phases '%standard-phases)
                             (outputs '("out"))
                             (search-paths '())
                             (system (%current-system))
                             (guile #f)
                             (imported-modules %crosstool-ng-build-system-modules)
                             (modules '((guix build crosstool-ng-build-system)
                                        (guix build utils)))
                             )
  "Build Crosstool-ng toolchain"

  (define build
    #~(begin
        (use-modules #$@(sexp->gexp modules))

        #$(with-build-variables inputs outputs
            #~(crosstool-ng-build #:name #$name
                                  #:source #+source
                                  #:system #$system
                                  #:test-target #$test-target
                                  #:tests? #$tests?
                                  #:phases #$(if (pair? phases)
                                                 (sexp->gexp phases)
                                                 phases)
                                  #:outputs %outputs
                                  #:search-paths '#$(sexp->gexp
                                                     (map search-path-specification->sexp
                                                          search-paths))
                                  #:inputs %build-inputs))))

  (mlet %store-monad ((guile (package->derivation (or guile (default-guile))
                                                  system #:graft? #f)))
    (gexp->derivation name build
                      #:system system
                      #:target #f
                      #:modules imported-modules
                      #:guile-for-build guile)))

(define crosstool-ng-build-system
  (build-system
    (name 'crosstool-ng)
    (description "Crosstool-ng build system")
    (lower lower)))
