(define-module (embedded-dev build crosstool-ng-build-system)
  #:use-module ((guix build gnu-build-system) #:prefix gnu:)
  #:use-module (guix build utils)
  #:use-module (ice-9 match)
  #:export (%standard-phases
            crosstool-ng-build))

;; Commentary:
;;
;; Builder-side code of the standard crosstool build procedure.

;; TODO: Pass through parallel option
;;
;; Code:
(define* (companion_tools_for_build #:allow-other-keys)
  (invoke "ct-ng companion_tools_for_build"))
(define* (companion_libs_for_build #:allow-other-keys)
  (invoke "ct-ng companion_libs_for_build"))
(define* (binutils_for_build #:allow-other-keys)
  (invoke "ct-ng binutils_for_build"))
(define* (companion_tools_for_host #:allow-other-keys)
  (invoke "ct-ng companion_tools_for_host"))
(define* (companion_libs_for_host #:allow-other-keys)
  (invoke "ct-ng companion_libs_for_host"))
(define* (binutils_for_host #:allow-other-keys)
  (invoke "ct-ng binutils_for_host"))
(define* (libc_headers #:allow-other-keys)
  (invoke "ct-ng libc_headers"))
(define* (kernel_headers #:allow-other-keys)
  (invoke "ct-ng kernel_headers"))
(define* (cc_core #:allow-other-keys)
  (invoke "ct-ng cc_core"))
(define* (libc_main #:allow-other-keys)
  (invoke "ct-ng libc_main"))
(define* (cc_for_build #:allow-other-keys)
  (invoke "ct-ng cc_for_build"))
(define* (cc_for_host #:allow-other-keys)
  (invoke "ct-ng cc_for_host"))
(define* (libc_post_cc #:allow-other-keys)
  (invoke "ct-ng libc_post_cc"))
(define* (companion_libs_for_target #:allow-other-keys)
  (invoke "ct-ng companion_libs_for_target"))
(define* (binutils_for_target #:allow-other-keys)
  (invoke "ct-ng binutils_for_target"))
(define* (debug #:allow-other-keys)
  (invoke "ct-ng debug"))
;; (define* (test_suite #:allow-other-keys)
;;   (invoke "ct-ng test_suite"))
(define* (finish #:allow-other-keys)
  (invoke "ct-ng finish"))

(define %standard-phases
  (modify-phases gnu:%standard-phases
                 (delete 'unpack)
                 (delete 'bootstrap)
                 (delete 'configure)
                 (delete 'build)
                 (delete 'check)
                 (delete 'install)
                 (add-after 'patch-generated-file-shebangs 'companion_tools_for_build companion_tools_for_build)
                 (add-after 'companion_tools_for_build 'companion_libs_for_build companion_libs_for_build)
                 (add-after 'companion_libs_for_build 'binutils_for_build binutils_for_build)
                 (add-after 'binutils_for_build 'companion_tools_for_host companion_tools_for_host)
                 (add-after 'companion_tools_for_host 'companion_libs_for_host companion_libs_for_host)
                 (add-after 'companion_libs_for_host 'binutils_for_host binutils_for_host)
                 (add-after 'binutils_for_host 'libc_headers libc_headers)
                 (add-after 'libc_headers 'kernel_headers kernel_headers)
                 (add-after 'kernel_headers 'cc_core cc_core)
                 (add-after 'cc_core 'libc_main libc_main)
                 (add-after 'libc_main 'cc_for_build cc_for_build)
                 (add-after 'cc_for_build 'cc_for_host cc_for_host)
                 (add-after 'cc_for_host 'libc_post_cc libc_post_cc)
                 (add-after 'libc_post_cc 'companion_libs_for_target companion_libs_for_target)
                 (add-after 'companion_libs_for_target 'binutils_for_target binutils_for_target)
                 (add-after 'binutils_for_target 'debug debug)
;;                 (add-after 'debug 'test_suite test_suite)
;;                 (add-after 'test_suite 'finish finish)
                 (add-after 'debug 'finish finish)
                 ))
