(define-module (embedded-dev packages crosstool-ng)
  #:use-module (guix packages)
  #:use-module (guix git-download)
  #:use-module (guix licenses)
  #:use-module (guix profiles)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system python)
  #:use-module (guix build utils)
  #:use-module (guix gexp)
  #:use-module (gnu packages python)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages gettext)
  #:use-module (gnu packages texinfo)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages base) ;; contains which?
  #:use-module (gnu packages flex)
  #:use-module (gnu packages gawk)
  #:use-module (gnu packages man)
  #:use-module (gnu packages bison)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages ncurses)
  #:use-module (embedded-dev build-system crosstool-ng)
  )


(define-public crosstool-ng
  (package
   (name "crosstool-ng")
   (version "1.26.0")
   (source (origin
            (method git-fetch)
            (uri (git-reference
                  (url "https://github.com/crosstool-ng/crosstool-ng.git")
                  (commit (string-append "crosstool-ng-" version))))
            (sha256
             (base32
              "04z7zwhxfbjqrd4j16lviilppsd8phwi8zv2rs4jpkmqni6856j1")
             )
            ))
   (build-system gnu-build-system)
   (native-inputs
    (list autoconf
          automake
          gettext-minimal
          libtool
          texinfo
          bison
          flex
          gawk
          unzip
          which
          help2man
          python
          ncurses
          pkg-config))
   (arguments
    '(#:phases (modify-phases %standard-phases
                              (add-before 'bootstrap 'fix-version-gen
                                          (lambda* _
                                                   (patch-shebang "maintainer/git-version-gen")
                                                   )))))

   (synopsis "A versatile (cross-)toolchain generator.")
   (description "A versatile (cross-)toolchain generator.")
   (home-page "https://crosstool-ng.github.io/docs/")
   (license (list gpl2 gpl2+ gpl3+ lgpl2.1 lgpl3+))
   ))

(define-public ct-ng-riscv64-unknown-elf
  (package
    (name "ct-ng-riscv64-unknown-elf")
    (source (plain-file "defconfig"
                        '("CT_CONFIG_VERSION=\"4\"\n"
                          "CT_EXPERIMENTAL=y\n"
                          "CT_ARCH_RISCV=y\n"
                          "# CT_DEMULTILIB is not set\n"
                          "CT_ARCH_USE_MMU=y\n"
                          "CT_ARCH_64=y\n"
                          "CT_DEBUG_GDB=y\n"
                          "# CT_GDB_CROSS_PYTHON is not set\n")))
    (version "1.26.0")
    (build-system crosstool-ng-build-system)
    (arguments `(#:sample "riscv64-unknown-elf"))
    (synopsis "A crosstool-ng based riscv64 unknown elf toolchain")
    (description "A crosstool-ng based riscv64 unknown elf toolchain")
    (home-page "https://crosstool-ng.github.io/docs/")
    (license (list gpl2 gpl2+ gpl3+ lgpl2.1 lgpl3+))
    ))

(define-public ct-ng-riscv64-unknown-linux-gnu
  (package
    (name "ct-ng-riscv64-unknown-linux-gnu")
    (source (plain-file "defconfig"
                        '("CT_CONFIG_VERSION=\"4\"\n"
                          "CT_EXPERIMENTAL=y\n"
                          "CT_ARCH_RISCV=y\n"
                          "# CT_DEMULTILIB is not set\n"
                          "CT_ARCH_USE_MMU=y\n"
                          "CT_ARCH_64=y\n"
                          "CT_ARCH_ARCH=\"rv64gc\"\n"
                          "CT_KERNEL_LINUX=y\n"
                          "CT_CC_LANG_CXX=y\n"
                          "CT_DEBUG_GDB=y\n"
                          "# CT_GDB_CROSS_PYTHON is not set\n"
                          "# CT_GDB_GDBSERVER is not set\n")))
    (version "1.26.0")
    (build-system crosstool-ng-build-system)
    (arguments `(#:sample "riscv64-unknown-linux-gnu"))
    (synopsis "A crosstool-ng based riscv64 unknown elf toolchain")
    (description "A crosstool-ng based riscv64 unknown elf toolchain")
    (home-page "https://crosstool-ng.github.io/docs/")
    (license (list gpl2 gpl2+ gpl3+ lgpl2.1 lgpl3+))
    ))
