#include <hurd.h>
#include <stdio.h>
#include <mach.h>
#include <fcntl.h>

#include "stack.h"

int
main (int argc, char* argv[])
{
  file_t stack_server_port_file;

  stack_server_port_file = file_name_lookup ("/tmp/stack", 0, O_RDWR);

  if (stack_server_port_file == MACH_PORT_NULL)
    error (1, errno, "Server not found");

  for (;;)
    {
      char        command[2];
      stack_data_t stack_data;
      int data;
      kern_return_t kr;
      int i;

      kr = stack_initialize (stack_server_port_file, &stack_data);
      if (kr == KERN_SUCCESS)
	printf ("Stack : Initialize : Success!!\n");
      else
	printf ("Stack : Initialize : failed coz of %s\n", mach_error_string (kr));
      break;

      printf ("stack-> ");
      if (scanf("%1s", command) < 1)
	{
	  printf("\n");
	  break;
	}
      switch (command[0])
	{
	case '?':
	case 'h':
	  printf("Commands:\n");
	  printf ("p <int>   - push an integer in to the stack\n");
	  printf ("o         - pop an integern from the stack\n");
	  printf ("t         - returns the top of the stack\n");
	  printf ("e         - empty the stack\n");
	  printf ("q         - quits the client\n");
	  break;
	case 'p':
	  /*
	    Do a push operation in to the stack.
	  */
	  if (scanf ("%d", &data) < 1)
	    {
	      printf ("Syntax error - push!!\n");
	      break;
	    }
	  kr = stack_push (stack_server_port_file, data, &stack_data);
	  if (kr == KERN_SUCCESS)
	    {
	      printf ("Displaying the contents of the stack : \n");
	      for (i = stack_data.top-1; i > -1 ; i--)
		printf ("%d\n", stack_data.data[i]);
	    }
	  else
	    printf ("Stack : Push : failed coz of %s\n", mach_error_string (kr));
	  break;

	case 'o':
	  /*
	    Do a pop operation from the stack.
	  */
	  kr = stack_pop (stack_server_port_file, &stack_data, &data);
	  if (kr == KERN_SUCCESS)
	    {
	      printf ("Popped element from the stack is %d\n", data);
	      printf ("Displaying the contents of the stack : \n");
	      for (i = stack_data.top-1; i > -1 ; i--)
		printf ("%d\n", stack_data.data[i]);
	    }
	  else
	    printf ("Stack : Pop : failed coz of %s\n", mach_error_string (kr));
	  break;

	case 't':
	  /*
	    Do a top operation in to the stack.
	  */
	  kr = stack_top (stack_server_port_file, stack_data, &data);
	  if (kr == KERN_SUCCESS)
	    {
	      printf ("Top element of the stack is %d\n", data);
	      printf ("Displaying the contents of the stack : \n");
	      for (i = stack_data.top-1; i > -1 ; i--)
		printf ("%d\n", stack_data.data[i]);
	    }
	  else
	    printf ("Stack : Top : failed coz of %s\n", mach_error_string (kr));
	  break;

	case 'e':
	  /*
	    Do an empty operation in to the stack.
	  */
	  kr = stack_empty (stack_server_port_file, &stack_data);
	  if (kr == KERN_SUCCESS)
	    {
	      printf ("Displaying the contents of the stack : \n");
	      for (i = stack_data.top-1; i > -1 ; i--)
		printf ("%d\n", stack_data.data[i]);
	    }
	  else
	    printf ("Stack : Empty : failed coz of %s\n", mach_error_string (kr));
	  break;
	case 'q':
	  exit (0);
	}
    }
  exit (0);
}
