#include <mach.h>
#include "stack_types.h"

kern_return_t 
do_initialize (mach_port_t server, 
	       stack_data_t* stack_data_p)
{
  stack_data_p->top = 0;
  memset (stack_data_p->data, 0x00, 10 * sizeof (int));
  return KERN_SUCCESS;
}

kern_return_t 
do_push (mach_port_t server,
	 int data,
	 stack_data_t* stack_data_p)
{
  kern_return_t retval;
  if (stack_data_p->top < 9)
    {
      stack_data_p->data[stack_data_p->top] = data;
      stack_data_p->top++;
      retval = KERN_SUCCESS;
    }
  else
    {
      printf ("Data overflow!!\n");
      retval = KERN_FAILURE;
    }
  return retval;
}

kern_return_t 
do_pop (mach_port_t server,
	stack_data_t* stack_data_p,
	int* popped_data_p)
{
  kern_return_t retval;
  if (stack_data_p->top > 0)
    {
#ifdef DEBUG
      printf ("Element popped up from the stack is %d\n", 
	      stack_data_p->data[stack_data_p->top-1]);
#endif
      *popped_data_p = stack_data_p->data[stack_data_p->top-1];
      stack_data_p->data[--stack_data_p->top] = 0;
      retval = KERN_SUCCESS;
    }
  else
    {
      printf ("Stack underflow!!\n");
      retval = KERN_FAILURE;
    }
  return retval;
}

kern_return_t 
do_top (mach_port_t server,
	stack_data_t stack_data,
	int* top_data_p)
{
  kern_return_t retval;
  if (stack_data.top > 0)
    {
#ifdef DEBUG
      printf ("Element popped up from the stack is %d\n", 
	      stack_data.data[stack_data.top-1]);
#endif
      *top_data_p = stack_data.data[stack_data.top-1];
      retval = KERN_SUCCESS;
    }
  else
    {
      printf ("Stack is empty!!\n");
      retval = KERN_FAILURE;
    }
  return retval;
}

kern_return_t 
do_empty (mach_port_t server,
	  stack_data_t* stack_data_p)
{
  kern_return_t retval;
  if (stack_data_p->top > 0)
    {
      memset (stack_data_p->data, 0x00, stack_data_p->top * sizeof (int));
      stack_data_p->top = 0;
      retval = KERN_SUCCESS;
    }
  else
    {
      printf ("Stack is already empty!!\n");
      retval = KERN_FAILURE;
    }
  return retval;
}

kern_return_t 
do_uninitialize (mach_port_t server,
		 stack_data_t* stack_data_p)
{
  memset (stack_data_p->data, 0x00, 10 * sizeof (int));
  stack_data_p->top = 0;
  return KERN_SUCCESS;
}
