#include <stdio.h>
#include <mach.h>
#include <argp.h>
#include <fcntl.h>
#include <hurd/ports.h>

#define MAX_MSG_SIZE                           512

static mach_port_t stack_service;
static mach_port_t real_stack_node;
static  mach_port_t stack_control;
struct port_bucket *stack_bucket;
struct port_class *stack_class;

boolean_t stack_server (mach_msg_header_t *InHeadP, 
			mach_msg_header_t *OutHeadP);

/*
int 
main ()
{
  kern_return_t kr;
  (void) mach_port_allocate (mach_task_self(), 
			     MACH_PORT_RIGHT_RECEIVE, &stack_service);
  kr = netname_check_in (name_server_port, "demoStackServer", 
 			 mach_task_self(), stack_service);
  if (kr != KERN_SUCCESS)
    quit (1, "Stack: netname_check_in: %s\n", 
 	  mach_error_string (kr));
  kr = mach_msg_server(stack_server, MAX_MSG_SIZE, stack_service);
  printf("Stack: mach_msg_server: %s\n", mach_error_string(kr));
  return 0;

}
*/

int
main ()
{
  error_t err;
  mach_port_t bootstrap, right;

  printf ("Before task_get_bootstrap_port \n");
  task_get_bootstrap_port (mach_task_self (), &bootstrap);
  if (bootstrap == MACH_PORT_NULL)
    error (1, 0, "Must be started as a translator");

  printf ("Before mach_port_allocate \n");

  /*  mach_port_allocate (mach_task_self(), 
			     MACH_PORT_RIGHT_RECEIVE, &stack_service);
  mach_port_insert_right (mach_task_self(), stack_service,
			  stack_service, MACH_MSG_TYPE_MAKE_SEND);
  */
  /*err = fsys_startup (bootstrap, stack_service, MACH_MSG_TYPE_MAKE_SEND, &real_stack_node);*/
  printf ("After mach_port_allocate \n");

  stack_bucket = (struct port_bucket *) ports_create_bucket ();
  stack_class = (struct port_class *) ports_create_class (NULL, NULL);
  err = ports_create_port (stack_class, stack_bucket, sizeof (mach_port_t),
			   &stack_control);
  if (err)
    error (3, err, "Stack: ports_create_port:\n");

  right = ports_get_send_right (&stack_control);

  err = fsys_startup (bootstrap, 0, right, 
		      MACH_MSG_TYPE_COPY_SEND, &real_stack_node);
  if (err)
    error (1, err, "Starting up the translator!!\n");
  ports_port_deref (&stack_control);

  mach_port_deallocate (mach_task_self (), right);
  mach_port_deallocate (mach_task_self (), bootstrap);
  
  printf ("started as a translator\n");
  ports_manage_port_operations_one_thread (stack_bucket, stack_server, 0);
  return 0;
}
