# Set DERIVEDDIR to any absolute or relative location if you want to change the
# default (../derived), where all derived objects are to be placed. But note
# that you should always choose a non-existing directory here, as a "make cleanall"
# will mercyless remove that directory, including its content.
DERIVEDDIR:=derived/overall
# One may define a default platform to be built. This may then be superseeded
# as desired by passing another platform through command line argument to make
# (e.g. make PLATFORM:=cpu1).
# Each platform will be build in a subdirectory of DERIVEDDIR that has the
# platform's name. Furthermore, each platform requires a related include file
# having the platform's name and the extension .mk (make will complain
# otherwise, which ensures that only valid platforms may be built).
# The platform specific .mk files may contain any platform specific settings,
# allowing to control the build process on a per platform basis as needed.
# Note that no <platform>.mk file is needed when the platform is the empty
# string. In this case, all derived objects will directly be stored under
# DERIVEDDIR and any settings may be done in the user.mk file. But note that
# any settings in a <platform>.mk file will take precedence over the settings
# in the user.mk for related platforms.
# Finally, another interesting feature of the PLATFORM variable is that one may
# override it in a user.mk file that belongs to an EasyMake makefile that creates
# a dependent target (see PREREQUISITES). As the most important example, one
# may put the following line:
# override PLATFORM:=
# into that user.mk to create a common dependent target for all platforms.
# Hint: Try out "make PLATFORM=cpu1" to run the build for another platform
# and "make PLATFORM=xxx" to see that you cannot build for a non-existing
# platform.
PLATFORM:=cpu2
# The name of the final target (default is the current directories' name).
TARGET:=tdc
# A list of tools that transform source files to intermediate targets. The list
# must adhere to the following format:
# COMPILERS:=<tool_1 with parameters>§<source extension_1>§<target extension_1>;\
#            <tool_2 with parameters>§<source extension_2>§<target extension_2>;\
#            ...;\
#            <tooln with parameters>§<source extension_n>§<target extension_n>;
# Make will deternine the "right" tool from that list from its related "source
# extension": It must match the source extension of the files that are to be
# transformed by that tool. The "target extension" describes how the names of the
# target files are to be derived from the source file names.
# Besides any ordinary "parameters" that may be passed to the "tools", one may also
# pass any special make variables that are valid in make reciepes. As the most
# notable examples, one may pass $< to pass the source file and $@ to pass the
# target file to the tool. But note that the dollar characters need to be escaped
# by a second dollar to delay their expansion until their rule is evaluated by
# EasyMake. Also, any occurrences of hash charachters (#) need to be escaped by
# a backslash (\).
# Another important aspect is EasyMake's automatic generation of dependencies, e.g.
# when C source files include header files. In such cases, the target should not
# only be rebuilt when its source file changes, but also when any included header
# files are modified. To accomlish this, EasyMake relies on "tool" to provide the
# required dependency information in a dependency file having the name of the target,
# but with the target's extension replaced by ".d". Fortunately, this dependencyfile
# may very easily be created for both C and C++ files with the GNU compiler by passing
# it the command line option -MD. This method has the advantage that the dependency
# information is generated in one go during compilation. Less capable compilers
# may use the preprocessor together with some shell script code for this purpose.
# Some good examples may be found at http://mad-scientist.net/make/autodep.html,
# together with further background information and an interesting idea to generate
# dependency information for _any_ "tools".
# As a last resort fallback, EasyMake creates an empty dependency file if no
# dependency file has been created by "tool", e.g. because no dependencies exist.
# The following example adds three additional entries to generate targets:
# The first describes how intermediate targets are made from files that end with
# tst2.c.
# The second changes the default behaviour for compiling files that end with "2.c".
# Furthermore, it uses the preprocessor to generate the dependencies. Note the && to
# concatenate the invocation of the compiler and the preprocessor: The semicolon must
# never be used here, as it is the separator of different entries. Besides that, using
# && has the positive side effect that make stops whenever either the compiler _or_
# the preprocessor returns with a failure, while using a semicolon to concatenate the
# commands would hide a compilation failure from make.
# The last entry is trivial: For any source .o file, it creates the target .obj by
# simply copying the source to the target. 
COMPILERS+=gcc -MD -DSORT -c -o $$@ $$< §tst2.c §tst2_c.o;\
           $(CC) -g -c -o $$@ $$< &&\
           $(CPP) $$< | sed -n 's%^\# *[0-9][0-9]* *"\([^"]*\)".*%$$@: \1%p' |\
                        sed -e '/<built-in>/d' -e '/<command-line>/d' |\
                        sort -u >$$(basename $$@).d §2.c §2_c.o;\
	   cp $$< $$@ §.o §.obj;
# Source files that are matched by source extensions several times would create
# competing rules having the same target but different reciepes. In such cases,
# make issues a warning, indicating that the last rule genetated from the compiler
# list will be used to create the target. To avoid this warning, EasyMake removes
# these duplicates.
# If the duplicates are explicitly wanted, maybe because one file should be compiled
# twice but differently, the DUPLICATES variable may be set to anything not being the
# empty string. But note that the target specification in the compiler list must then
# differ, otherwise make will simply ignore one of the duplicates (according to the
# setting of SORTED, see below), issuing a related warning.
DUPLICATES:=
# If SORTED is set to the empty string, the last matching extension in the compiler
# list will be used to create the target. If it is set to anything else, then EasyMake
# uses the longest matching extension.
SORTED:=true
# EasyMake uses the following compiler list by default:
# COMPILERS:=$(CC) $(CFLAGS) $(addprefix -D,$(DEFINES)) $(addprefix -I,$(INCLUDES))\
#                  -MD -c -o $$@ $$< §.c §_c.o;\
#            $(CXX) $(CXXFLAGS) $(addprefix -D,$(DEFINES)) $(addprefix -I,$(INCLUDES))\
#                  -MD -c -o $$@ $$< §.cpp §_cpp.o;
# Hence, one may control the default build by setting the following variables as needed:
CC:=gcc
CXX:=/usr/bin/g++
CFLAGS:=-O1
CXXFLAGS:=-O2
DEFINES:=xxx=7 yyy
# Any relative path will be relative to the current (i.e. user.mk's) directory.
INCLUDES:=/usr/local/include .
# By default, EasyMake compiles and links all files in in and below the current directory
# that have a matching source file extension in the compiler list. This may be
# overwritten by explicitly specifying the source files to be compiled. To do this,
# use SOURCES.c for .c files, SOURCES.cpp for .cpp files, SOURCES.o for .o files,
# SOURCES2.c for files ending with 2.c and SOURCEStst2.c for files ending with tst2.c.
# The available SOURCES<...> variables are just built form SOURCES and the related
# source extension of the compiler list.
SOURCES.cpp:=xxx.cpp
# Note here that the default setting may be used to create the new one.
SOURCES.c:=$(filter-out tst.c,$(SOURCES.c))
# Here, we add a file to the default sources with extension 2.c that even doesn't exist.
# Thus, make would complain that it has no rule to create it.
SOURCES2.c+=version2.c
# Thus, we just tell EasyMake how to create it! As version2.c is a derived file,
# it is created at the proper location in the derived files' directory tree.
# Note the ifeq arround the rule. It is necessary because both user.mk and
# <platform>.mk will be included by EasyMake several times. And while EasyMake
# takes care that nothing "unexpected" happens due to the multiple inclusion for all
# the variables that EasyMake knows (i.e. that are documented here), it cannot forsee
# any other arbitrary content that may be added by the user. Therefore, the user
# must take care that such code is evaluated only once. A typical pattern how this may
# be done is shown below. As an alternative, any content that should be evaluated
# only once may be put into the file once.mk, as it will be included exactly once at
# end of the EasyMake makefile if it is available.
ifeq ($(ONCE),)
version2.c:
	touch version2.c
endif
ONCE:=true
# By default, all derived objects are linked together to make up the target. The
# OBJECTS variable allows to add or remove objects from linking as desired.
OBJECTS:=$(filter %/main_c.o cpp/tst_cpp.o %2_c.o,$(OBJECTS)) xxx_cpp.o
# Easymake tries to guess the right linker, using
# LINKER:=$(CXX) $(addprefix -Wl,$(LINKERFLAGS)) $(addprefix -l,$(LIBRARIES)) $(addprefix -L,$(LIBDIRS)) -o
# if any .cpp files are part of the build and using
# LINKER:=$(CC) $(addprefix -Wl,$(LINKERFLAGS)) $(addprefix -l,$(LIBRARIES)) $(addprefix -L,$(LIBDIRS)) -o
# otherwise. This may be changed here.
# Note the use of the predefined variable COMMA in the example below: It expands
# to a literal comma, whereas the real comma that comes right afterwards will
# be interpreted as parameter separator to function $(addprefix ...).
LINKER:=gcc $(addprefix -Wl$(COMMA),$(LINKERFLAGS)) $(addprefix -l,$(LIBRARIES)) $(addprefix -L,$(LIBDIRS)) -o
# One may pass flags, libraries and their directories to the default linker:
LINKERFLAGS:=-O1 -Map=$(TARGET).map
LIBRARIES:=pthread
LIBDIRS:=.
# Any other directory that contains an EasyMake makefile may be listed here. The
# resulting targets are by default linked with the top-level target.
PREREQUISITES=../sub1 ../sub2
# Similar to OBJECTS, all PREREQUISITES are linked with the target by default.
# The TARGETS variable allows to adjust this as desired.
TARGETS:=$(filter-out %sub1/tst.a,$(TARGETS))
