<?xml version="1.0"?>
<!--
  Copyright 2001-2006 Hippo (www.hippo.nl)
  
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  
  http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License. 
-->
<xsl:stylesheet version="1.0"  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
  <xsl:variable name="temp" select="concat('*:/content/website/home/newsletters/',//response/response/propstat/prop/displayname)"/>
  
    <xsl:template match="/root">
    
    <locationmap xmlns="http://apache.org/forrest/locationmap/1.0">
      

      <components>
        <matchers default="locationmap">
          <matcher name="locationmap" src="nl.hippo.forrest.locationmap.WildcardLocationMapHintMatcher"/>
        </matchers>
      </components>
      
      <locator>
        
        <match pattern="types:**">
          
          <match pattern="*:/content/website/home/reference_tables/reference_table_detail">
            <location src="reference_table"/>
          </match>
          
          <match pattern="*:/content/website/home/reference_tables/reference_table_detail/**">
            <location src="reference_table"/>
          </match>
          
          <match pattern="*:/content/website/home/transactions/transaction_detail">
            <location src="transaction"/>
          </match>
          
          <match pattern="*:/content/website/home/transactions/transaction_detail/**">
            <location src="transaction"/>
          </match>
          
          
          <match pattern="*:/content/website/home/webservices/webservice_detail">
            <location src="webservice"/>
          </match>
          
          <match pattern="*:/content/website/home/webservices/webservice_detail/**">
            <location src="webservice"/>
          </match>
          
          <xsl:element name="match">
            <xsl:attribute name="pattern"><xsl:value-of select="$temp"/></xsl:attribute>
            <location src="latest_change" />
          </xsl:element>
          
          <match pattern="*:/content/website">
            <location src="siteweb"/>
          </match>
          
          <match pattern="*:/content/website/**">
            <location src="siteweb"/>
          </match>
          
          <!-- "catch all" matcher -->
          <match pattern="**">
            <location src=""/>
          </match>
          
        </match>
        
        <match pattern="preview-url:**">
          
        </match>
        
      </locator>
      
    </locationmap>
    
  </xsl:template>
  
  
</xsl:stylesheet>