#!/bin/sh

# ----------------------------- #
# Static definitions
# ----------------------------- #

LOGFILE=/logs/htdig/tmp/konverter/doc2html
OUTDIR=/data/htdig/tmp

WVHTML=/usr/local/bin/wvHtml

# ----------------------------- #
# Catching input parameters
# ----------------------------- #

infile="$1"
mimetype="$2"
url="$3"
conf="$4"

# ----------------------------- #
# Check the mime type
# ----------------------------- #

if [ "$mimetype" != "application/msword" ]
then
        echo "$url is $mimetype instead of application/msword" >> ${LOGFILE} 2>&1
        exit 1
fi

# ----------------------------- #
# Create temporary output file
# ----------------------------- #
outfile=wvhtml.out-$$
rm -f "${OUTDIR}/$outfile"

# ----------------------------- #
# Start conversion
# ----------------------------- #
"$WVHTML" --targetdir=${OUTDIR} "$infile" "$outfile" >> ${LOGFILE} 2>&1

# ----------------------------- #
# cat file to stdout
# ----------------------------- #
if [ -s "${OUTDIR}/$outfile" ]
then
        cat "${OUTDIR}/$outfile"
        retcode=0
else
        (
	echo "$0: $infile couldn't be converted to HTML (URL: $3)"
        ) >> ${LOGFILE} 2>&1
        retcode=1
fi

# ----------------------------- #
# Clean up
# ----------------------------- #
rm -f "${OUTDIR}/$outfile" "/tmp/wvhtml"*
exit $retcode

# EOF

