#!/bin/sh

# ----------------------------- #
# Static definitions
# ----------------------------- #

PPTHTML=/usr/local/bin/ppthtml

OUTDIR=/data/htdig/tmp

LOGFILE=/logs/htdig/tmp/konverter/ppttohtml

# ----------------------------- #
# Catching input parameters
# ----------------------------- #

infile="$1"
mimetype="$2"
url="$3"
conf="$4"

# ------------------------------------------------------------------ #
# ppthtml does not set the document title so we change this to the
# documents name
# ------------------------------------------------------------------ #

name="`basename \"$3\" | cut -d. -f1`"

# ----------------------------- #
# Check the mime type
# ----------------------------- #

if [ "$mimetype" != "application/vnd.ms-powerpoint" ]
then
	echo "$url is $mimetype instead of application/vnd.ms-powerpoint" >&2
	exit 1
fi

# ----------------------------- #
# Create temporary output file
# ----------------------------- #

outfile=ppthtml.out-$$
rm -f "${OUTDIR}/$outfile"

# --------------------------------- #
# Start conversion and fix TITLE tag
# --------------------------------- #

"$PPTHTML" $infile | sed -e \
"s%HEAD>%HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=iso-8859-1\">%" -e \
"s#<TITLE>${infile}</TITLE>#<TITLE>${name}</TITLE>#" \
> "${OUTDIR}/$outfile" 

# ----------------------------- #
# cat file to stdout
# ----------------------------- #

if [ -s "${OUTDIR}/$outfile" ]
then
	cat "${OUTDIR}/$outfile"
	retcode=0
else
	(
        echo "$0: $infile couldn't be converted to HTML (Outfile: ${outfile}, URL: $3)"
	) >> ${LOGFILE} 2>&1
	retcode=1
fi

# ----------------------------- #
# Clean up
# ----------------------------- #


rm -f "${OUTDIR}/$outfile" "/tmp/ppttohtml"*
exit $retcode

# EOF
