#include "WordSearcher.h"
#include "HtWordType.h"
#include "ResultList.h"
#include "HtWordReference.h"
#include "defaults.h"

WordSearcher::WordSearcher(const String &filename) :
	references(config)
{
	references.Open(filename, O_RDONLY);
}

ResultList *
WordSearcher::Search(const String &word)
{
	ResultList *result = 0;
	if(IsIgnore(word))
	{
		result = new ResultList;
		result->Ignore();
	}
	else
	{
		result = Fetch(word);
	}
	return result;
}

bool
WordSearcher::IsIgnore(const String &word)
{
	String copy = word;
	return 0 != WordType::Instance()->Normalize(copy);
}

ResultList *
WordSearcher::Fetch(const String &word)
{
cout << "FETCH: " << word << endl;
	ResultList *result = 0;
	List *refs = references[word];

	if(refs && refs->Count())
	{
cout << "REFERENCES: " << refs->Count() << endl;
		result = new ResultList;
		DocMatch *match = new DocMatch;

		refs->Start_Get();
		HtWordReference *ref = (HtWordReference *)refs->Get_Next();
		match->SetId(ref->DocID());
		match->SetAnchor(ref->Anchor());
		result->add(match);
		unsigned int current = ref->DocID();
//cout << "MATCH" << result->Count() << ": " << match->GetId() << endl;
		while(ref)
		{
			if(ref->DocID() != current)
			{
				match = new DocMatch;
				match->SetId(ref->DocID());
//cout << "MATCH" << result->Count() << ": " << match->GetId() << endl;
				match->SetAnchor(ref->Anchor());
				result->add(match);
				current = ref->DocID();
			}
			match->AddLocation(
				new Location(
					ref->Location(),
					ref->Location(),
					ref->Flags()));
			ref = (HtWordReference *)refs->Get_Next();
		}
		result->Add(current, match);
	}
	return result;
}
