//
// Collection.cc
//
//
#if RELEASE
#endif

#include "htsearch.h"
#include "Collection.h"
#include "ResultMatch.h"
#include "WeightWord.h"
#include "StringMatch.h"
#include "QuotedStringList.h"
#include "URL.h"
#include <fstream.h>
#include <stdio.h>
#include <ctype.h>
#include <syslog.h>
#include <locale.h>
#include "HtURLCodec.h"

//*****************************************************************************
//
Collection::Collection(const char *name, const char *word_file, 
                       const char *index_file, const char *doc_file, 
                       const char *doc_excerpt)
{
    isopen = 0;
    collectionName = name;
    wordFile = word_file;
    indexFile = index_file;
    docFile = doc_file;
    docExcerpt = doc_excerpt;
    matches = NULL;
}

Collection::~Collection()
{
    Close();
}

void
Collection::Open()
{
    if (!isopen)
    {
        docDB.SetCompatibility(config.Boolean("uncoded_db_compatible", 1));
        docDB.Read(docFile, indexFile, docExcerpt);
    }
    isopen = 1;
}

void
Collection::Close()
{
    if (isopen)
    {
        docDB.Close();
    }
    isopen = 0;
}

DocumentRef *
Collection::getDocumentRef(int id)
{
    Open();
    return docDB[id];
}

int 
Collection::ReadExcerpt(DocumentRef &ref) 
{ 
    Open();
    return docDB.ReadExcerpt(ref); 
}
 

