#include "automata0.h"

struct Automata *criarAutomata(igraph_t *g, int num_estados, const int simulation_time, double porcent_inib, double pmax, double fator_proj_externa, igraph_vector_t *proj_externa, GRand *gen){
    struct Automata *autom = malloc(sizeof(struct Automata));

    autom->N = igraph_vcount(g);
    autom->num_estados = num_estados;
    autom->simulation_time = simulation_time;
    gerarPercept(g, porcent_inib, fator_proj_externa, autom->N, proj_externa, gen);
    criarPesos(g, pmax, gen);

    return autom;
}


// TODO- completar o destruir automata
void destruirAutomata(struct Automata *autom){

    if(autom){

        free(autom);
    }
}

int compara(char *s, char *t){
 
    for ( ; (*s == *t) ; s++, t++)
	if (*s == '\0')
            return 0;
    return *s - *t;
}

void criarPesos(igraph_t *g, double pmax, GRand *rgen){

    double el;

    for(int i = 0; i < igraph_ecount(g); i++){

       el = (double) g_rand_double_range(rgen, 0.0, pmax);
       SETEAN(g, "peso", i, el);

    }

}

//** Atualiza nos vizinhos de nos em atividade com probabilidade de entrar em atividade, lista todos os nos atualizados em podem_entrar_em_atividade **//
void probabilidades(igraph_t *g, Automata autom, igraph_vector_int_t *ativos, igraph_vector_int_t *primeiros_vizinhos, igraph_vector_int_t *proj_externa, igraph_adjlist_t *adjlist){
 
    int num_ativos = igraph_vector_int_size(ativos);
    int num_vizinhos;
    int tamanho0,tamanho1;
    int viz;
    int ativo;
    double prob;
   
    double fator_pe = (double) GAN(g, "fator_proj_externa");
    igraph_vector_int_t *vizinhos;
    igraph_real_t indice;

    for(int i = 0; i < num_ativos; i++){
        
      
        ativo =  VECTOR(*ativos)[i];     
        vizinhos = igraph_adjlist_get( adjlist, ativo);
        num_vizinhos = (int) igraph_vector_int_size(vizinhos);
     

        for(int j = 0; j < num_vizinhos; j++){

     
            viz = (int) VECTOR(*vizinhos)[j];       

            if( ( (int) retornaEstado(g, viz) == 0) && compara(retornaTipo(g, ativo), "excit") == 0 && (int) retornaAtivavel(g, viz) != 0 ){

                prob = (double) retornaProb(g, viz);
                SETVAN(g,"prob_ativar", viz, prob*(1.0- ((double) retornaPeso(g, ativo, viz) ) ) );

              } else if( ( (int) retornaEstado(g, viz) == 0) && compara(retornaTipo(g, ativo), "excit" ) == 0 &&  (int) retornaAtivavel(g, viz) == 0 ){

               indice = viz;
 
               tamanho0 = igraph_vector_int_size(primeiros_vizinhos);
               tamanho1 = igraph_vector_int_capacity(primeiros_vizinhos);

               if( tamanho1 > tamanho0 )
                   igraph_vector_int_push_back(primeiros_vizinhos, indice);
               else{
                   igraph_vector_int_reserve(primeiros_vizinhos, tamanho0 + 1);
                   igraph_vector_int_push_back(primeiros_vizinhos, indice);
               }        
                     
               SETVAN(g, "ativavel", viz, 1);

               if( (int) VAN(g, "proj_externa", viz) == 1){                    
                    
                   SETVAN(g,"prob_ativar", viz, fator_pe*(1.0 - ((double) retornaPeso(g, ativo, viz) ) ) );

               }else{
                       
                    prob = (double) retornaProb(g, viz);
                    SETVAN(g,"prob_ativar", viz, prob*(1.0 - ((double) retornaPeso(g, ativo, viz) ) ) );
           
               }

            }else if( ( (int) retornaEstado(g, viz) == 0) && compara(retornaTipo(g, ativo), "inib" ) == 0 &&  (int) retornaAtivavel(g, viz) != 0 ){

                prob = (double) retornaProb(g, viz);
                SETVAN(g,"prob_ativar", viz, prob*(1.0- ((double) retornaPeso(g, ativo, viz) ) ) );

            } else if( ( (int) retornaEstado(g, viz) == 0) && compara(retornaTipo(g, ativo), "inib" ) == 0 &&  (int) retornaAtivavel(g, viz) == 0 ){

                SETVAN(g, "ativavel", viz, 1);
                indice = viz;
                tamanho0 = igraph_vector_int_size(primeiros_vizinhos);
                tamanho1 = igraph_vector_int_capacity(primeiros_vizinhos);

                if( tamanho1 > tamanho0 )
                    igraph_vector_int_push_back(primeiros_vizinhos, indice);
                else{
                    igraph_vector_int_reserve(primeiros_vizinhos, tamanho0 + 1);
                    igraph_vector_int_push_back(primeiros_vizinhos, indice);
                }
            
            
                if( (int) VAN(g, "proj_externa", viz) == 1){
                    
                    SETVAN(g,"prob_ativar", viz, fator_pe*( (double) retornaPeso(g, ativo, viz) ) );                  

                }else{
                       
                    prob = (double) retornaProb(g, viz);                  
                    SETVAN(g,"prob_ativar", viz, prob + ( (double) retornaPeso(g, ativo, viz) ) );                 

                }

            }

        }
    
    }    

    int t = igraph_vector_int_size(proj_externa);
    for(int i = 0; i < t; i++ ){
        
        viz = VECTOR(*proj_externa)[i];

        if( ( (int) retornaEstado(g, viz) == 0) &&  ((int) retornaAtivavel(g, viz) == 0) ){
       
            SETVAN(g, "prob_ativar", viz, fator_pe );
            SETVAN(g, "ativavel", viz, 1);

            tamanho0 = igraph_vector_int_size(primeiros_vizinhos);
            tamanho1 = igraph_vector_int_capacity(primeiros_vizinhos);

            if( tamanho1 > tamanho0 )
                igraph_vector_int_push_back(primeiros_vizinhos, viz);
            else{
                igraph_vector_int_reserve(primeiros_vizinhos, tamanho0 + 1);
                igraph_vector_int_push_back(primeiros_vizinhos, viz);
            }  
        }
    }

}


void simular(igraph_t *g, Automata autom, igraph_vector_int_t *em_atividade_iniciais, igraph_adjlist_t *adjlist, GRand *rgen, char *gravadens){

   int num_trans, num_ativo, num_refrat;
   int j, tamanho0, tamanho1;
   int est_refrat = 2 % autom->num_estados;
   FILE *f;
   igraph_vector_t transicoes;
   igraph_vector_t deterministicos;
   igraph_vector_int_t primeiros_vizinhos;
   igraph_vector_int_t proj_externa;
   igraph_vector_int_t ativos;
   igraph_vector_init(&transicoes, 0);
   igraph_real_t el;
   double dens = 0.0;
   double P = 0.0;
   double T = 0.0;
   igraph_vector_init(&deterministicos, 0);
   igraph_vector_int_init(&primeiros_vizinhos, 0);

    int c = 0;
    for(int j = 0; j < autom->N; j++) if( (int) VAN(g, "proj_externa", j) == 1 ) c++; 
    igraph_vector_int_init(&proj_externa, c);
    c = 0;
    for(int j = 0; j < autom->N; j++){ if( (int) VAN(g, "proj_externa", j) == 1 ){
      
        VECTOR(proj_externa)[c] = j;
        c++;
    }
    
    }
   
     int tamanho = igraph_vector_int_size(em_atividade_iniciais);
     int indice;
    
     for(int i = 0; i < tamanho; i++){

         indice = (int) VECTOR(*em_atividade_iniciais)[i];
         SETVAN(g, "estado", indice, 1);

     }

   igraph_vector_int_copy(&ativos, em_atividade_iniciais);
  
   f = fopen(gravadens,"w");

   for(int t = 0; t < autom->simulation_time; t++){
       dens = densidade(autom, &ativos);
       fprintf(f,"%f\n",dens);
       
       probabilidades(g, autom, &ativos, &primeiros_vizinhos, &proj_externa, adjlist); // atualiza probabilidades de transicao 

       tamanho0 = igraph_vector_int_size(&primeiros_vizinhos);
       tamanho1 = igraph_vector_int_capacity(&primeiros_vizinhos);
 
       if(tamanho1 > tamanho0 && tamanho0 != 0 )
       igraph_vector_int_resize_min(&primeiros_vizinhos);

       num_trans = igraph_vector_int_size(&primeiros_vizinhos);
       
       igraph_vector_reserve( &transicoes, num_trans);

       for(j = 0; j < num_trans; j++){

           el = (double) g_rand_double_range(rgen, 0.0, 1.0);
           tamanho0 = igraph_vector_size(&transicoes);
           tamanho1 = igraph_vector_capacity(&transicoes);
           if( tamanho1 > tamanho0 )
                   igraph_vector_push_back(&transicoes, el);
               else{
                   igraph_vector_reserve(&transicoes, tamanho0 + 1);
                   igraph_vector_push_back(&transicoes, el);
               }// se nao houver memoria alocada, i.e se tamanho do vetor == memoria alocada, ele vai alocar mais tamanho do vetor de memoria, o que dobra a memoria alocada
       }

       tamanho0 = igraph_vector_size(&transicoes);
       tamanho1 = igraph_vector_capacity(&transicoes);

       if(tamanho1 > tamanho0 && tamanho0 != 0)
       igraph_vector_resize_min(&transicoes);
       
       num_ativo =  igraph_vector_int_size(&ativos);

       if(num_ativo == 0){
         resetAtr(g);
         fclose(f);
         igraph_vector_destroy(&transicoes);
         igraph_vector_destroy(&deterministicos);
         igraph_vector_int_destroy(&primeiros_vizinhos);
         igraph_vector_int_destroy(&proj_externa);
         igraph_vector_int_destroy(&ativos); 
         break;
       }

       num_refrat = igraph_vector_size(&deterministicos);
 
       int a;
       int b;
       j = num_refrat-1;

       while( j >= 0 ){

           b = VECTOR(deterministicos)[j];
           a = ( ( (int) retornaEstado(g, b) ) + 1) % autom->num_estados;
           SETVAN(g, "estado", b, a);
            
           if(a == 0){
               igraph_vector_remove(&deterministicos, j);
               j--;
               SETVAN(g, "ativavel", b, 0);
           }else j--;

       }

       j = num_ativo-1;       
       while( j >= 0 ){
       
           b = VECTOR(ativos)[j];
           igraph_vector_int_remove(&ativos, j);
           SETVAN(g, "estado", b, est_refrat);
           if(est_refrat == 0) SETVAN(g, "ativavel", b, 0);
           j--;
           //teste memoria vetor:

        }

       for(j = 0; j < num_trans ; j++){

           a = VECTOR(primeiros_vizinhos)[j];
           P = (double) retornaProb(g, a);
           T = VECTOR(transicoes)[j];

           if( (T < (1.0 - P)) && P <= 1.0){
              
               SETVAN(g, "estado", a, 1);

               tamanho0 = igraph_vector_size(&deterministicos);
               tamanho1 = igraph_vector_capacity(&deterministicos);

               if( tamanho1 > tamanho0 )
                   igraph_vector_push_back(&deterministicos, a);
               else{
                   igraph_vector_reserve(&deterministicos, tamanho0 + 1);
                   igraph_vector_push_back(&deterministicos, a);
               }          

               tamanho0 = igraph_vector_int_size(&ativos);
               tamanho1 = igraph_vector_int_capacity(&ativos);

               if( tamanho1 > tamanho0 )
                   igraph_vector_int_push_back(&ativos, a);
               else{
                   igraph_vector_int_reserve(&ativos, tamanho0 + 1);
                   igraph_vector_int_push_back(&ativos, a);
               }
               
            }else SETVAN(g, "ativavel", a, 0);
       }
       
       tamanho0 = igraph_vector_size(&deterministicos);
       tamanho1 = igraph_vector_capacity(&deterministicos);
   
       if(tamanho1 > tamanho0 && tamanho0 != 0)
       igraph_vector_resize_min(&deterministicos);
     


       tamanho0 = igraph_vector_int_size(&ativos);
       tamanho1 = igraph_vector_int_capacity(&ativos);
      
       if(tamanho1 > tamanho0 && tamanho0 != 0)
       igraph_vector_int_resize_min(&ativos);



       igraph_vector_clear(&transicoes);
       igraph_vector_int_clear(&primeiros_vizinhos);

   }
   
   resetAtr(g);   

}
