
#include <string.h>
#include <ctype.h>
#include "gguid.h"

class changeset_applied {
public:
	char					* change_set;	// change set applied to.

	class changeset_applied	* next;

	changeset_applied( const char * str )
		: change_set( strdup( str ) )
	{
	}
	
	void dump_content( ostream &fo )
	{
		fo << "Applied Changeset: '" << change_set << "'\n";
	}

	void dump_sql_content( ostream &fo, gg_guid &i_guid )
	{
		fo <<
			"INSERT INTO AppliedChangeSets (\n"
			"	ChangeLogGuid,\n"
			"	AppliedChangeSetGuid\n"
			") VALUES (\n"
			"	'"; i_guid.print_hex( fo ); fo << "',\n"
			"	'" << change_set << "'\n"
			");\n\n";
	}

};

class bug_type {
public:
	enum bug_state {
		FIXED,
		PARTIAL,
		RELATED
	};

	bug_state	  state;
	char		* bugid;
	char		* bugprefix;
	int			  bugnum;
	bug_type	* next;

	const char * state_o_bug()
	{
		switch ( state ) {
			case FIXED : return "FIXED"; break;
			case PARTIAL : return "PARTIAL"; break;
			case RELATED : return "RELATED"; break;
			default : return "Unknown"; break;
		}
	}

	bug_type( const char * s, bug_state istate )
		: state( istate )
	{
		int	len = strlen( s );
		bugid = new char[ len + 1 ];
		char * t;
		const char * t2;
		const char * t3;
		for ( t = bugid, t2 = s ; * t2; t2 ++, t ++ ) {
			if ( !isdigit( *t2 ) ) {
				*t = toupper( *t2 );
				t3 = t2;
			} else {
				*t = *t2;
			}
		}

		bugprefix = new char[ len = (t3-s+2) ];
		memcpy( bugprefix, bugid, len-1 );
		bugprefix[len-1] = 0;

		bugnum = atoi( t3 + 1 );
		
		*t = 0;
	}

	void dump_content( ostream &fo )
	{
		fo << "Bug: '" << bugid << "' reference: '" << state_o_bug() << "'\n";
	}
	
	void dump_sql_content( ostream &fo, gg_guid &i_guid )
	{
		fo <<
			"INSERT INTO BugDispositions (\n"
			"	ChangeLogGuid,\n"
			"	BugId,\n"
			"	BugType,\n"
			"	BugNum,\n"
			"	Disposition\n"
			") VALUES (\n"
			"	'"; i_guid.print_hex( fo ); fo << "',\n"
			"	'" << bugid << "',\n"
			"	'" << bugprefix << "',\n"
			"	" << bugnum << ",\n"
			"	'" << state_o_bug() << "'\n"
			");\n\n";
	}
	
};

class bug_list {
public:
	
	bug_type			* list;
	changeset_applied	* cslist;
	bug_type::bug_state	  state;
	bool				  expect_bugs;
	bool				  has_applied;
	
	bug_list()
		: list( 0 ), cslist( 0 ), state( bug_type::FIXED ),
			expect_bugs( true ), has_applied( false )
	{
	}

	void add_changeset_applied( changeset_applied * cs )
	{
		cs->next = cslist;
		cslist = cs;
	}

	void add_changeset_applied( const char * str )
	{
		if ( has_applied ) {
			has_applied = false;
			add_changeset_applied( new changeset_applied( str ) );
		}
	}

	void add_bug( bug_type * bug )
	{
		bug->next = list;
		list = bug;
	}
	
	void add_bug( const char * str )
	{
		add_bug( new bug_type( str, state ) );
	}
	
	void dump_content( ostream &fo )
	{
		fo << "Bug list\n";

		for ( bug_type * entry = list; entry; entry = entry->next ) {
			entry->dump_content( fo );
		}

		for ( changeset_applied * entry = cslist; entry; entry = entry->next ) {
			entry->dump_content( fo );
		}

	}
	
	void dump_sql_content( ostream &fo, gg_guid &i_guid )
	{
		for ( bug_type * entry = list; entry; entry = entry->next ) {
			entry->dump_sql_content( fo, i_guid );
		}

		for ( changeset_applied * entry = cslist; entry; entry = entry->next ) {
			entry->dump_sql_content( fo, i_guid );
		}

	}
};

void parse_bugs( bug_list * bl, const char * str, int len );

