#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <iostream.h>
#include <time.h>

#ifndef __gguid_h
#define __gguid_h

struct gi_guid {
	unsigned char guid[16];
};

static char to_hex[] = "0123456789ABCDEF";
#define HiHex( ch ) ( to_hex[ ( ( ( (unsigned)(ch) ) >>4 )& 0xf) ] )
#define LoHex( ch ) ( to_hex[ (((unsigned)(ch))& 0xf) ] )

static char to_hexl[] = "0123456789abcdef";
#define HiHexL( ch ) ( to_hexl[ ( ( ( (unsigned)(ch) ) >>4 )& 0xf) ] )
#define LoHexL( ch ) ( to_hexl[ (((unsigned)(ch))& 0xf) ] )

typedef unsigned long long u64;

inline u64 rdtsc(void) {
    u64 clock;
    __asm__ __volatile__("rdtsc" : "=A" (clock));
    return clock;
}

class gg_guid_state {
public:
	bool		is_initialized;
	gi_guid		base_seed;

	gg_guid_state()
		: is_initialized( false )
	{
	}

	void fill_random( gi_guid & g )
	{
		// The cost of reading from /dev/random is large for some reason.
		// So we only go there once and then we add one each time.
		if ( ! is_initialized ) {
			char	* fault = 0;
			int fd = ::open( "/dev/random", O_RDONLY );

			int ir = sizeof( time_t );
			int	i;
	
			// place the unix system time at tge beginning
			time_t	tis;
			::time( & tis );
	
			// Make a endian independant solutuion
			for ( unsigned char * gc = g.guid, i = sizeof( tis ); i; i --, gc ++ ) {
				* gc = ( tis >> ( ( i - 1 ) * 8 ) );
			}

			while (
				( ir < 16 )
				&& ( -1 != ( i = ::read( fd, g.guid + ir, 16 -ir ) ) )
			) {
				ir += i;
			}
			
			is_initialized = true;
			
			if ( i == -1 ) {
				* fault = 1;
				// dump core !
			}
			::close( fd );

			base_seed = g;
		} else {

			// simply add the time stamp counter - make a new value
			( * ( u64 * ) ( base_seed.guid + 16 - sizeof( u64 ) ) ) ++;

			g = base_seed;

		}

			
	}

};

#ifdef gg_guid_define
#define gg_guid_extern
#else
#define gg_guid_extern extern
#endif

gg_guid_extern gg_guid_state gg_guid_state_obj;

class gg_guid : public gi_guid {
public:

	void make( )
	{

		int		ir = 0;
		int		i;

		// Go fill
		gg_guid_state_obj.fill_random( this[0] );		

	}

	void print_hex( ostream &of )
	{
		char    buf[33];

		for ( int i = 0; i < 16; i ++ ) {
			buf[ i*2   ] = HiHexL( guid[ i ] );
			buf[ i*2+1 ] = LoHexL( guid[ i ] );
		}
		buf[ 32 ] = 0;
		of << buf;
	}

	void print_hex( char * buf )
	{
		for ( int i = 0; i < 16; i ++ ) {
			buf[ i*2   ] = HiHexL( guid[ i ] );
			buf[ i*2+1 ] = LoHexL( guid[ i ] );
		}
	}

	void print_guid( ostream &of )
	{
		int		len=4+2+1+16*2;
		char	buf[len];
		buf[ 0] = '{';
		buf[ 1] = HiHex( guid[  0 ] );
		buf[ 2] = LoHex( guid[  0 ] );
		buf[ 3] = HiHex( guid[  1 ] );
		buf[ 4] = LoHex( guid[  1 ] );
		buf[ 5] = HiHex( guid[  2 ] );
		buf[ 6] = LoHex( guid[  2 ] );
		buf[ 7] = HiHex( guid[  3 ] );
		buf[ 8] = LoHex( guid[  3 ] );
		buf[ 9] = '-';
		buf[10] = HiHex( guid[  4 ] );
		buf[11] = LoHex( guid[  4 ] );
		buf[12] = HiHex( guid[  5 ] );
		buf[13] = LoHex( guid[  5 ] );
		buf[14] = '-';
		buf[15] = HiHex( guid[  6 ] );
		buf[16] = LoHex( guid[  6 ] );
		buf[17] = HiHex( guid[  7 ] );
		buf[18] = LoHex( guid[  7 ] );
		buf[19] = '-';
		buf[20] = HiHex( guid[  8 ] );
		buf[21] = LoHex( guid[  8 ] );
		buf[22] = HiHex( guid[  9 ] );
		buf[23] = LoHex( guid[  9 ] );
		buf[24] = '-';
		buf[25] = HiHex( guid[ 10 ] );
		buf[26] = LoHex( guid[ 10 ] );
		buf[27] = HiHex( guid[ 11 ] );
		buf[28] = LoHex( guid[ 11 ] );
		buf[29] = HiHex( guid[ 12 ] );
		buf[30] = LoHex( guid[ 12 ] );
		buf[31] = HiHex( guid[ 13 ] );
		buf[32] = LoHex( guid[ 13 ] );
		buf[33] = HiHex( guid[ 14 ] );
		buf[34] = LoHex( guid[ 14 ] );
		buf[35] = HiHex( guid[ 15 ] );
		buf[36] = LoHex( guid[ 15 ] );
		buf[37] = '}';
		buf[38] = 0;

		of << buf;
	}
};

#endif // #ifndef __gguid_h
