

/* ======== FindChangeSets ============================================ */

DROP FUNCTION FindChangeSets();

CREATE FUNCTION FindChangeSets()
RETURNS TEXT AS '
declare
    psrec   record;
    lsrec   record;
	retval  text;
	window	reltime;
begin

	-- use a 6 minute ( 3 before 3 after ) window
	window := reltime(180);

	-- Find a candidate ChangeSetGuid
	select
		CL1.ChangeLogGuid
	into
		psrec
	from
		ChangeLogs as CL1, ChangeLogs as CL2
	where
		not ( CL1.ChangeLogGuid = CL2.ChangeLogGuid )
		and ( CL1.CVSROOT = CL2.CVSROOT )
		and ( CL1.UserId = CL2.UserId )
		and ( CL1.LogMessageMD5 = CL2.LogMessageMD5 )
		and ( CL1.UnixTime <= ( CL2.UnixTime + window ) )
		and ( CL1.UnixTime >= ( CL2.UnixTime - window ) )
		and ( CL2.ChangeSetGuid = NULL )
		and ( CL1.ChangeLogGuid = CL1.ChangeSetGuid )
	order by
		CL1.UnixTime
	limit
		1;

	-- it there is no change set combos
    if not found then

		-- check to see if there are some loners
		select
			CL1.ChangeLogGuid
		into
			psrec
		from
			ChangeLogs as CL1
		where
			CL1.ChangeSetGuid = NULL
		order by
			CL1.UnixTime
		limit
			1;

		if not found then
			-- all change logs are associated with change sets.
			return ''NONE FOUND'';
		end if;
		
		-- set the change set id on this change log
		update
			ChangeLogs
		set
			ChangeSetGuid = ChangeLogs.ChangeLogGuid
		where
			psrec.ChangeLogGuid = ChangeLogs.ChangeLogGuid
		;

		insert into ChangeSets (
			ChangeSetGuid,
			BugsExported,
			EmailsDone
		) values (
			psrec.ChangeLogGuid,
			''NO'',
			''NO''
		);

	end if;

	-- Update all matching change logs to use this change set
	update
		ChangeLogs
	set
		ChangeSetGuid = psrec.ChangeLogGuid
	from
		ChangeLogs as CL1
	where
		not ( CL1.ChangeLogGuid = ChangeLogs.ChangeLogGuid )
		and ( CL1.CVSROOT = ChangeLogs.CVSROOT )
		and ( CL1.UserId = ChangeLogs.UserId )
		and ( CL1.LogMessageMD5 = ChangeLogs.LogMessageMD5 )
		and ( CL1.UnixTime <= ( ChangeLogs.UnixTime + window ) )
		and ( CL1.UnixTime >= ( ChangeLogs.UnixTime - window ) )
		and ( ChangeLogs.ChangeSetGuid = NULL )
		and ( psrec.ChangeLogGuid = CL1.ChangeLogGuid )
	;

	return psrec.ChangeLogGuid;

end;
' language 'plpgsql';


/* ======== FindAllChangeSets ========================================= */

DROP FUNCTION FindAllChangeSets();

CREATE FUNCTION FindAllChangeSets()
RETURNS INT4 AS '
declare
    psrec   record;
	retval  int4;
	num_found int4;
begin

	num_found := 0;
	loop
		select FindChangeSets() as result into psrec;
		if ( psrec.result = ''NONE FOUND'' ) then
			exit;
		end if;
		num_found := num_found + 1;
	end loop;

	return num_found;
end;
' language 'plpgsql';


/* TRY IT OUT */
/*
begin;
select FindAllChangeSets();

select
	ChangeSets.ChangeSetGuid, count( ChangeLogs.ChangeLogGuid )
from
	ChangeSets, ChangeLogs
where
	ChangeSets.ChangeSetGuid = ChangeLogs.ChangeSetGuid
group by
	( ChangeSets.ChangeSetGuid )
;

select * from ListXS;

explain select * from ListXS;

select * from ChangeLogs;

select * from ListXS where 'co,mma' = filename;

explain select * from ListXS where 'co,mma' = filename;

select * from FileRevisions where 'co,mma' = filename;

explain select * from FileRevisions where 'co,mma' = filename;

rollback;
*/
