/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE file.
 */
package org.apache.commons.collections;

import java.util.LinkedList;

/** A multithreaded blocking queue, useful for implementing 
  * producer-consumer style threading patterns.
  *
  * @author <a href="mailto:jstrachan@apache.org">James Strachan</a>
  */
public class SynchronizedQueue {
    
    private LinkedList list = new LinkedList();
    
    
    public SynchronizedQueue() {
    }
    
    /** adds a new object to the end of the queue
      */
    public synchronized void add(Object object) {
        list.add( object );
        notify();
    }

    /** Removes the first object from the queue, blocking until one is available
      */
    public synchronized Object remove() {
        while (true) {
            if ( ! list.isEmpty() ) {
                Object answer = list.removeFirst();
                if ( answer != null ) {
                    return answer;
                }
            }
            try {
                wait();
            }
            catch (InterruptedException e) {
            }
        }
    }
    
    /** Removes the first object from the queue without blocking.
      * @return the first object removed from the queue or null if the
      * queue is empty
      */
    public synchronized Object removeNoWait() {
        if ( ! list.isEmpty() ) {
            return list.removeFirst();
        }
        return null;
    }
        
}
