/*
 * $Header: /home/cvspublic/jakarta-commons/collections/src/test/org/apache/commons/collections/TestCollection.java,v 1.5 2001/07/14 23:33:27 craigmcc Exp $
 * $Revision: 1.5 $
 * $Date: 2001/07/14 23:33:27 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Commons", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.commons.collections;

import java.util.Collection;
import java.util.HashMap;

import junit.framework.*;

/**
 * Tests base {@link java.util.Collection} methods and contracts on
 * {@link Map}s using the {@link MapCollection} adapter.
 *
 * @author Chuck Burdick
 * @version $Id: TestCollection.java,v 1.5 2001/07/14 23:33:27 craigmcc Exp $
 **/
public class TestMapCollection extends TestCollection {
   public TestMapCollection(String testName) {
      super(testName);
   }

   /**
    * Return a new, empty {@link Collection} to used for testing.
    */
   public Collection makeCollection() {
      return makeMapCollection();
   }

   public MapCollection makeMapCollection() {
      return new MapCollection(new HashMap());
   }

   public static Test suite() {
      return new TestSuite(TestMapCollection.class);
   }

   public static void main(String args[]) {
      String[] testCaseName = { TestMapCollection.class.getName() };
      junit.textui.TestRunner.main(testCaseName);
   }

   public void testNullRemove() {
      MapCollection c = makeMapCollection();
      c.getMap().put("A", "a");
      c.getMap().put("B", null);
      assertTrue("Removing 'A' results in a change", c.remove("A"));
      assertTrue("Removing 'B' results in a change", c.remove("B"));
      assertTrue("Removing 'C' results in no change", !c.remove("C"));
   }
}




