package org.apache.james.core;
/**
 * MimeMessageInputStreamSource.java
 *
 *
 * Created:
 * 
 * @author
 * @version
 *
 * Modified by <a href="mailto:okidz@pindad.com">Oki DZ</a>
 * Thu Oct  4 15:15:27 WIT 2001
 * 
 */
import java.io.*;

public class MimeMessageInputStreamSource extends MimeMessageSource {

    private InputStream in = null;
    private String key, fileName;
    private long size;
    private File file;

    //If you try to access this size first, it will load it into a temp file
    //  and work from there.

    public MimeMessageInputStreamSource(String key, InputStream in) {
        this.key = key;
	this.in = in;
	size = -1;
	fileName = null;
    }

    /**
     * Return an input stream to the data
     */
    public synchronized InputStream getInputStream() throws IOException {
	if (size == -1) {
	    return in;
	} else {
	    return new BufferedInputStream(new FileInputStream(fileName));
	} 
    }
    
    /**
     * If not already, read the stream into a temp file
     */
    public synchronized long getSize() throws IOException {
	BufferedInputStream inbuff;
	BufferedOutputStream outbuff;
	long count = 0;
	if (fileName == null) {
	    inbuff = new BufferedInputStream(in);
	    file = File.createTempFile(key, null);
	    fileName = file.getAbsolutePath();
	    outbuff = new BufferedOutputStream(new FileOutputStream(file));
	    for (int i = 0; (i = inbuff.read()) != -1;) {
		outbuff.write(i);
		count++;
	    }
	    size = count;
	    outbuff.close();
	    inbuff.close();
	}	
	return size;
    }

    public void finalize() {
	try {
	    file.delete();
	} catch(Exception ie) {
	    // Fixme: log this
	}
    }
}
