package org.apache.james.transport.mailets;
/**
 * ToPostmaster.java
 *
 *
 * Created: Sat Sep 29 11:27:08 2001
 *
 * @author <a href="mailto:okidz@pindad.com">Oki DZ</a>
 * @version 1.0
 *
 * <mailet match="RecipientList=vacation" class="ToPostmaster">
 *  <!-- sendingAddress>postmaster@domain.com</sendingAddress -->
 *  <subject>Notice from James.</subject>
 *  <notice>The recipients are in vacation.</notice>
 * </mailet>
 *
 */
import java.lang.*;
import java.io.*;
import java.util.*;
import java.net.*;

import javax.mail.*;
import javax.mail.internet.*;

import org.apache.avalon.framework.component.*;

import org.apache.mailet.*;
import org.apache.james.*;
import org.apache.james.core.*;
import org.apache.james.util.*;
import org.apache.james.services.*;

public class ToPostmaster extends GenericMailet {

    protected MimeMessage message;
    protected Mail reply;
    protected MailAddress notifier;
    protected MailAddress postmaster; 
    protected String subjectText;
    protected String noticeText;
    private MailRepository userInbox;
    private MailServer mailServer;
    private InetAddress hostAddress;

    public void init() throws MessagingException {
	try {
	    postmaster = getMailetContext().getPostmaster();
	    hostAddress = InetAddress.getLocalHost();
	    ComponentManager componentManager = (ComponentManager)
		getMailetContext()
		.getAttribute(Constants.AVALON_COMPONENT_MANAGER);
	    mailServer = (MailServer)
		componentManager.lookup("org.apache.james.services.MailServer");
	    userInbox = mailServer.getUserInbox(postmaster.getUser());
	    if (getInitParameter("sendingAddress") == null) {
		notifier = new 
		    MailAddress("mail-server@" + hostAddress.getHostName());
	    } else {
		notifier = new MailAddress(getInitParameter("sendingAddress"));
	    }
	    if (getInitParameter("subject") == null) {
		subjectText = "Autogenerated message.";
	    } else {
		subjectText = getInitParameter("subject");
	    }
	    if (getInitParameter("notice") == null) {
		noticeText = "Notice text.";
	    } else {
		noticeText = getInitParameter("notice");
	    }
	} catch(Exception e) {
	    throw new MessagingException(e.getMessage());
	}
    }  

    public void service(Mail mail) throws MessagingException {
	try {	
	    reply = newReply(mail);
	    mailServer.sendMail(reply);
	    mail.setState(Mail.GHOST);
	} catch(Exception e) {
	    throw new MessagingException(e.getMessage());
	}  
    }

    protected Mail newReply(Mail mail) throws MessagingException {
	message = mail.getMessage();
	Collection dnsServers;
	dnsServers = getMailetContext().getMailServers(notifier.getHost());
	Collection recipients = new Vector();
	recipients.add(postmaster.toString());
	Session session = Session
	    .getDefaultInstance(System.getProperties(), null);

	String dateString = RFC822DateFormat.toString(new Date());
	StringWriter headbuff = new StringWriter();
	PrintWriter headprint = new PrintWriter(headbuff, true);
	headprint.println("ReturnPath: <" + notifier.toString() + ">");
	headprint.println("Received: from " + hostAddress.getHostName() +
			  " ([" + hostAddress.getHostAddress() + "])");
	headprint.println("          by " + hostAddress.getHostName() +
			  " (" + getMailetContext().getServerInfo() + ")");
	headprint.println("          for <" + postmaster.toString() + ">; " +
			  dateString);
	headprint.println("Date: " + dateString);
	headprint.println("From: " + notifier.toString());
	headprint.println("To: " + postmaster.toString());
	headprint.println("Subject: " + subjectText);
	headprint.println("MIME-Version: 1.0");
	//
	StringWriter sout = new StringWriter();
	PrintWriter out = new PrintWriter(sout, true);
	out.println("Notice: ");
	out.println(noticeText);
	out.println();
	out.println("Original message details: ");
	if (message.getSubject() != null) {
	    out.println("\tSubject: " + message.getSubject());
	} 
	if (message.getSentDate() != null) {
	    out.println("\tDate: " + message.getSentDate());
	} 
	out.println("\tFrom: " + mail.getSender());
	out.print("\tTo: ");
	for (Iterator i = mail.getRecipients().iterator(); i.hasNext();) {
	    out.print(i.next().toString());
	    if (i.hasNext()) out.print(", ");
	} 
	out.println();
	int size = message.getSize();
	out.println("\tSize: " + size);
	MailImpl mc = null;
	MimeMessage msg = new MimeMessage(session);
	
	StringBuffer msgbuff = new StringBuffer();

	String headfilename, origfilename;
	File headfile = null;
	File file = null;
	OutputStream ostream = null;
	InputStream istream = null;

	MimeMultipart multipart;
	MimeBodyPart bodypart;
	PrintStream printstream;
	LineNumberReader lineReader;
	//
	String header = "";
	String body = "";
	String textInsert = sout.toString();
	Object o;

	try {
	    multipart = new MimeMultipart();
	    // new insert
	    bodypart = new MimeBodyPart();
	    bodypart.setContent(textInsert, "text/plain");
	    multipart.addBodyPart(bodypart);
	    o = message.getContent();
	    if (o instanceof Multipart) {
		// orig. attachment(s)
		MimeMultipart mp = (MimeMultipart) o;
		for (int i = 0, n = mp.getCount(); i < n; i++) {
		    MimeBodyPart bp = (MimeBodyPart) mp.getBodyPart(i);
		    multipart.addBodyPart(bp);
		} 
		file = File.createTempFile("topostmaster", null);
		origfilename = file.getAbsolutePath();
		ostream = new FileOutputStream(file);
		multipart.writeTo(ostream);
		ostream.close();
		// get boundary line
		istream = new FileInputStream(origfilename);
		lineReader = new 
		    LineNumberReader(new InputStreamReader(istream));
		headprint.println("Content-Type: MULTIPART/MIXED; BOUNDARY=\"" +
				  lineReader.readLine().substring(2) + "\"");
		headprint.println();
      		header = headbuff.toString();
		istream.close();
	    } else {		
		// orig. text
		bodypart = new MimeBodyPart();
		bodypart.setContent((String) message.getContent(),"text/plain");
		multipart.addBodyPart(bodypart);
		// 
		file = File.createTempFile("topostmaster", null);
		origfilename = file.getAbsolutePath();
		ostream = new FileOutputStream(file);
		multipart.writeTo(ostream);
		ostream.close();
		// get boundary line
		istream = new FileInputStream(origfilename);
		lineReader = new 
		    LineNumberReader(new InputStreamReader(istream));
		headprint.println("Content-Type: MULTIPART/MIXED; BOUNDARY=\"" +
				  lineReader.readLine().substring(2) + "\"");
		headprint.println();
		header = headbuff.toString();
		istream.close();
	    }
	    msgbuff.append(header);
	    istream = new BufferedInputStream(new FileInputStream(origfilename));
	    for (int i = 0; (i = istream.read()) != -1;) {
		msgbuff.append((char) i);
	    } 
	    istream.close();
	    msg.setText(msgbuff.toString());
	    mc = new MailImpl(mailServer.getId(), notifier, recipients);
	    mc.setMessage(msg);
	} catch(Exception e) {
	    log(e.getMessage());
	    throw new MessagingException(e.getMessage());
	} finally {
	    try {
		file.delete();
	    } catch(Exception e) {
		e.printStackTrace();
	    }
	}
	return mc;
    }

    public String getMailetInfo() {
	return "A mailet for forwarding messages to Postmaster";
    }

    public String getMailetName() {
	return getClass().getName();
    }

}
