package org.apache.james.transport.mailets;
/**
 * ToVirtualDomain.java
 *
 *
 * Created: Fri Oct  5 12:13:14 2001
 *
 * @author <a href="mailto:okidz@pindad.com">Oki DZ</a>
 * @version
 */
import java.lang.*;
import java.util.*;

import javax.mail.*;
import javax.mail.internet.*;

import org.apache.avalon.framework.component.*;

import org.apache.mailet.*;
import org.apache.james.*;
import org.apache.james.core.*;
import org.apache.james.services.*;
import org.apache.james.mailrepository.*;

public class ToVirtualDomain extends GenericMailet {
    
    private MailRepository userInbox;
    private MailServer mailServer;
    private String domainName;

    public void init() throws MessagingException {
	
	try {
	    if (getInitParameter("domain") == null) {
		throw new MessagingException("Domain name not defined");
	    } else {
		domainName = getInitParameter("domain").toLowerCase();
	    }
	    ComponentManager componentManager = (ComponentManager)
		getMailetContext()
		.getAttribute(Constants.AVALON_COMPONENT_MANAGER);
	    mailServer = (MailServer)
		componentManager.lookup("org.apache.james.services.MailServer");
	} catch(Exception e) {
	    log(e.getMessage());
	    throw new MessagingException(e.getMessage());
	}
    }

    public void service(Mail mail) throws MessagingException {
	MimeMessage msg = mail.getMessage();
	Collection origRecipients = mail.getRecipients();
	Vector domainRecipients = new Vector();
	Vector newRecipients = new Vector();
	String rcptDomain;
	try {
	    for (Iterator i = origRecipients.iterator(); i.hasNext();) {
		MailAddress rcpt = (MailAddress) i.next(); 
		rcptDomain = rcpt.getHost().toLowerCase();
		if (domainName.equals(rcptDomain)) { 
		    domainRecipients.add(rcpt);
		} else {
		    newRecipients.add(rcpt);
		}
	    }
	    for (Iterator i = domainRecipients.iterator(); i.hasNext();) {
		userInbox = mailServer
		    .getUserInbox(((MailAddress) i.next()).toString());
		userInbox.store((MailImpl) mail);
	    }
	    mailServer.sendMail(mail.getSender(), newRecipients, msg); 
	    mail.setState(Mail.GHOST);
	} catch(Exception e) {
	    log(e.getMessage());
	    throw new MessagingException(e.getMessage());
	}
    }
}
