/*
 * Decompiled with CFR 0.152.
 */
package no.rwr.engine;

import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import no.rwr.engine.Question;

public class Session {
    static List questionPool;
    static final int NUMBER_OF_QUESTIONS = 59;
    List questions;
    Date startTime;
    Date endTime;
    DateFormat dateFormat = new SimpleDateFormat("H:mm:ss");

    static {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(ClassLoader.getSystemResource("questions.bin").openStream());
            Question[] questionArray = (Question[])objectInputStream.readObject();
            questionPool = Arrays.asList(questionArray);
        }
        catch (Exception exception) {}
    }

    public Session() {
        Collections.shuffle(questionPool);
        int n = Math.min(questionPool.size(), 59);
        Iterator iterator = questionPool.subList(0, n).iterator();
        this.questions = new ArrayList();
        while (iterator.hasNext()) {
            this.questions.add(((Question)iterator.next()).copy());
        }
    }

    public Question getQuestion(int n) {
        return (Question)this.questions.get(n);
    }

    public int getQuestionCount() {
        return this.questions.size();
    }

    public String getTimeLeft() {
        if (this.endTime == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        calendar.setTime(this.endTime);
        calendar.add(11, -n);
        calendar.add(12, -n2);
        calendar.add(13, -n3);
        return this.dateFormat.format(calendar.getTime());
    }

    public boolean isTimeUp() {
        if (this.endTime == null) {
            return false;
        }
        return new Date().after(this.endTime);
    }

    public void start() {
        this.startTime = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(11, 2);
        calendar.add(12, 0);
        this.endTime = calendar.getTime();
    }
}

