/*
 * Decompiled with CFR 0.152.
 */
package no.rwr.engine;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import no.rwr.engine.GUIStyle;
import no.rwr.engine.Question;
import no.rwr.engine.QuestionPane;
import no.rwr.engine.QuestionPanelFactory;
import no.rwr.engine.Session;

public class SessionGUI {
    Session session;
    JPanel gui;
    JTextArea questionArea = new JTextArea(10, 60);
    JPanel qa = new JPanel();
    Box navigation = new Box(0);
    QuestionPane answerArea;
    JScrollPane scrollPane;
    JScrollPane sqArea;
    JButton next = new JButton("Next >>");
    JButton previous = new JButton("<< Previous");
    JButton done = new JButton("Finish");
    JLabel title = new JLabel("Dummy title");
    JLabel time = new JLabel("-:--:--");
    Timer timer;
    int currentQuestion;

    public SessionGUI(final ActionListener actionListener) {
        this.qa.setLayout(new BorderLayout());
        this.questionArea.setEditable(false);
        this.questionArea.setLineWrap(true);
        this.questionArea.setWrapStyleWord(true);
        this.questionArea.setMargin(GUIStyle.paddingInsets);
        this.questionArea.setFont(new Font("Monospaced", 0, this.questionArea.getFont().getSize()));
        this.navigation.add(this.previous);
        this.navigation.add(this.next);
        this.navigation.add(Box.createHorizontalGlue());
        this.navigation.add(this.done);
        this.title.setFont(GUIStyle.largeFont);
        this.time.setFont(GUIStyle.largeFont);
        Box box = new Box(0);
        box.add(this.title);
        box.add(Box.createHorizontalGlue());
        box.add(this.time);
        this.gui = new JPanel();
        this.gui.setLayout(new BorderLayout());
        this.gui.setBorder(GUIStyle.paddingBorder);
        this.gui.add((Component)box, "North");
        this.gui.add((Component)this.qa, "Center");
        this.gui.add((Component)this.navigation, "South");
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                --SessionGUI.this.currentQuestion;
                SessionGUI.this.prepareQuestion();
            }
        });
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ++SessionGUI.this.currentQuestion;
                SessionGUI.this.prepareQuestion();
            }
        });
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                timer.stop();
                this.flush();
                actionListener.actionPerformed(actionEvent);
            }
        });
    }

    public void flush() {
        this.qa.invalidate();
        if (this.answerArea != null) {
            this.qa.remove(this.scrollPane);
            this.qa.remove(this.sqArea);
            this.answerArea.dispose();
            this.answerArea = null;
            this.scrollPane = null;
        }
    }

    public Container getPane() {
        return this.gui;
    }

    public void prepareQuestion() {
        this.qa.invalidate();
        this.flush();
        Question question = this.session.getQuestion(this.currentQuestion);
        this.answerArea = QuestionPanelFactory.createQuestionPanel(question);
        this.scrollPane = new JScrollPane(this.answerArea, 21, 30);
        this.qa.add((Component)this.scrollPane, "South");
        this.questionArea.setText(question.getProblem());
        this.questionArea.setCaretPosition(0);
        this.sqArea = new JScrollPane(this.questionArea);
        this.qa.add((Component)this.sqArea, "Center");
        this.previous.setEnabled(this.currentQuestion != 0);
        this.next.setEnabled(this.currentQuestion + 1 != this.session.getQuestionCount());
        this.title.setText("Question " + (this.currentQuestion + 1) + ":");
        this.qa.validate();
    }

    public void setSession(Session session) {
        this.session = session;
        this.currentQuestion = 0;
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SessionGUI.this.time.setText(SessionGUI.this.session.getTimeLeft());
                if (SessionGUI.this.session.isTimeUp()) {
                    SessionGUI.this.time.setText("Time is up");
                    SessionGUI.this.previous.setEnabled(false);
                    SessionGUI.this.next.setEnabled(false);
                    SessionGUI.this.questionArea.setEnabled(false);
                    SessionGUI.this.qa.setEnabled(false);
                    if (SessionGUI.this.answerArea != null) {
                        SessionGUI.this.answerArea.setEnabled(false);
                    }
                    SessionGUI.this.title.setEnabled(false);
                    SessionGUI.this.timer.stop();
                }
            }
        });
        this.timer.start();
        this.prepareQuestion();
    }
}

