/*
 *	@(#)PickMouseBehavior.java 1.1 99/04/13 15:39:24
 *
 * Copyright (c) 1996-1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

package pickingExt;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.*;


/**
 * Base class that allows users to adding picking and mouse manipulation to
 * his scene graph (see PickDragBehavior for an example of how to extend
 * this base class). This class is useful for interactive apps.
 */

public abstract class PickMouseBehavior extends Behavior {
  
  /**
   * Portion of the scene graph to operate picking on.
   */
  protected PickObject pickScene;

  protected WakeupCriterion[] conditions;
  protected WakeupOr wakeupCondition;
  protected boolean buttonPress = false;

  protected TransformGroup currGrp;
  protected static final boolean debug = false;
  protected MouseEvent mevent;
  
  /** 
   * Creates a PickMouseBehavior given current canvas, root of the tree to
   * operate on, and the bounds.
   */
  public PickMouseBehavior(Canvas3D canvas, BranchGroup root, Bounds bounds){
    super();
    currGrp = new TransformGroup();
    currGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
    currGrp.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
    root.addChild(currGrp);
    pickScene = new PickObject(canvas, root);
  }

  public void initialize() {

    conditions = new WakeupCriterion[2];
    conditions[0] = new WakeupOnAWTEvent(Event.MOUSE_MOVE);
    conditions[1] = new WakeupOnAWTEvent(Event.MOUSE_DOWN);
    wakeupCondition = new WakeupOr(conditions);

    wakeupOn(wakeupCondition);
  }
  
  private void processMouseEvent(MouseEvent evt) {
    buttonPress = false;

    if (evt.getID()==MouseEvent.MOUSE_PRESSED |
	evt.getID()==MouseEvent.MOUSE_CLICKED) {
      buttonPress = true;
      return;
    }
    else if (evt.getID() == MouseEvent.MOUSE_MOVED) {
      // Process mouse move event
    }
  }
  
  public void processStimulus (Enumeration criteria) {
    WakeupCriterion wakeup;
    AWTEvent[] evt = null;
    int xpos = 0, ypos = 0;

    while(criteria.hasMoreElements()) {
      wakeup = (WakeupCriterion)criteria.nextElement();
      if (wakeup instanceof WakeupOnAWTEvent)
	evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
    }
    
    if (evt[0] instanceof MouseEvent){
      mevent = (MouseEvent) evt[0];

      if (debug)
	System.out.println("got mouse event");
      processMouseEvent((MouseEvent)evt[0]);
      xpos = mevent.getPoint().x;
      ypos = mevent.getPoint().y;
    }
    
    if (debug)
      System.out.println("mouse position " + xpos + " " + ypos);
    
    if (buttonPress){
      updateScene(xpos, ypos);
    }
    wakeupOn (wakeupCondition);
  }

  /**
   * Sets the pickMode for this behavior
   * @param mode The pick mode, either USE_GEOMETRY or USE_BOUNDS
   */  
  public void setPickMode(int pickMode) {
    pickScene.setPickMode(pickMode);
  }

  /**
   * Returns the pickMode for this behavior
   */ 
  public int getPickMode() {
    return pickScene.getPickMode();
  }

  /**
   * Sets the pick geometry shape type for this behavior
   * @param type The pick shape type, either SHAPE_RAY, SHAPE_APERTURE or
   * SHAPE_RAY_APERTURE. The default is SHAPE_RAY.
   */
  public void setPickShapeMode(int type) {
    pickScene.setPickShapeMode(type);
  }

  /**
   * Returns the pick geometry shape type 
   */
  public int getPickShapeMode() {
    return pickScene.getPickShapeMode();
  }

  /**
   * Sets the pick aperture for SHAPE_APERTURE mode for this behavior 
   * @param Point[] aperturePts The pick aperture, which should be a convex,
   * counter-clockwise loop of Points around 0,0
   */
  public void setPickAperture(Point[] aperturePts) {
      pickScene.setPickAperture(aperturePts);
  }

  /**
   * Returns the pick aperture for SHAPE_APERTURE mode for this behavior 
   */
  public Point[] getPickAperture() {
      return pickScene.getPickAperture();
  }

  /** Subclasses shall implement this update function 
   */
  public abstract void updateScene(int xpos, int ypos);
}

