/*
 *      @(#)TetrahedronILA.java 1.1 99/04/13 15:39:05
 *
 * Copyright (c) 1996-1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 *
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */

import javax.media.j3d.*;
import javax.vecmath.*;

class TetrahedronILA extends IndexedLineArray {

  TetrahedronILA() {
    super(4, GeometryArray.COORDINATES | GeometryArray.COLOR_3, 12);  
    
    Point3f verts[] = new Point3f[4];
    Color3f colors[] = new Color3f[4];
    
    verts[0] = new Point3f(1.0f,1.0f,1.0f);
    verts[1] = new Point3f(1.0f,-1.0f,-1.0f);
    verts[2] = new Point3f(-1.0f,-1.0f,1.0f);
    verts[3] = new Point3f(-1.0f,1.0f,-1.0f);

    colors[0] = new Color3f(1.0f, 0.0f, 0.0f);
    colors[1] = new Color3f(0.0f, 1.0f, 0.0f);
    colors[2] = new Color3f(0.0f, 0.0f, 1.0f);
    colors[3] = new Color3f(1.0f, 1.0f, 0.0f);
    
    int[] pntsIndex = new int[12];
    int[] clrsIndex = new int[12];

    pntsIndex[0] = 0;
    clrsIndex[0] = 0;
    pntsIndex[1] = 1;
    clrsIndex[1] = 1;

    pntsIndex[2] = 1;
    clrsIndex[2] = 1;
    pntsIndex[3] = 2;
    clrsIndex[3] = 2;

    pntsIndex[4] = 2;
    clrsIndex[4] = 2;
    pntsIndex[5] = 0;
    clrsIndex[5] = 0;

    pntsIndex[6] = 1;
    clrsIndex[6] = 1;    
    pntsIndex[7] = 3;
    clrsIndex[7] = 3;

    pntsIndex[8] = 2;
    clrsIndex[8] = 2;
    pntsIndex[9] = 3;
    clrsIndex[9] = 3;

    pntsIndex[10] = 0;
    clrsIndex[10] = 0;
    pntsIndex[11] = 3;
    clrsIndex[11] = 3;
    
    setCoordinates(0, verts);
    setCoordinateIndices(0, pntsIndex);
    setColors(0, colors);
    setColorIndices(0, clrsIndex);
  }
}
