 
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.event.*;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.geometry.Box;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.awt.image.DataBufferByte;
import java.awt.color.ColorSpace;
import java.awt.Transparency;
import com.sun.j3d.utils.geometry.*;
import java.awt.*;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.*;

public class Transparent extends Applet {

	//================================ 
 	public int LumToAlpha(double lum){
 	//================================
 		
 		int alph = -1;
		double n = 0.5;//0.5
		double a = 0.0;//1.5
		if (lum<a){
			alph = 0;
		}
		else if (lum>1-a){
			alph = 255;	
		}
		else {
			
			double lu = (lum - a)/(1-(2*a));
			double cos = Math.cos(Math.PI+ (Math.PI*lu) );
			double f = Math.pow(0.5+(0.5*cos),n);
			alph = (int)(255*f);
		}
		return alph;
 	}
 
  //=======================================================================
  public BranchGroup createSceneGraph(String RGB_file, String alpha_file) {
  //=======================================================================
	Color3f aColor  = new Color3f(0.2f, 0.2f, 0.2f);
	Color3f eColor  = new Color3f(0.0f, 0.0f, 0.0f);
	Color3f dColor  = new Color3f(0.2f, 1.0f, 0.6f);
	Color3f sColor  = new Color3f(1.0f, 1.0f, 1.0f);
	Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
	Color3f lColor2 = new Color3f(0.7f, 0.7f, 0.35f);
	Vector3f lDir1  = new Vector3f(-1.0f, -1.0f, -1.0f);
	Vector3f lDir2  = new Vector3f(0.0f, 0.0f, 1.0f);
	Color3f alColor = new Color3f(1.0f, 1.0f, 1.0f);

 	Button button = new java.awt.Button();
 	TextureLoader texRGB = new TextureLoader(RGB_file,
	  																			new String("RGB"),button);
	BufferedImage buf = (texRGB.getImage()).getImage();
	ColorModel cm = buf.getColorModel();
	 	
	//System.out.println("color model = "+cm);
	int fwidth = buf.getWidth();
	int fheight = buf.getHeight();
	System.out.println("image width = "+fwidth+" ,image height = "+fheight);
	
	WritableRaster wr = buf.getRaster();
	DataBuffer db = wr.getDataBuffer();
	int[] array = ((DataBufferInt)db).getData(); 
	long d = 3*(255*255);
	
	
	 
	TextureLoader texAlpha = new TextureLoader(alpha_file,
	  																			new String("RGB"),new java.awt.Button());
	BufferedImage bufA = (texAlpha.getImage()).getImage();
	ColorModel cmA = bufA.getColorModel();
	 	
	//System.out.println("color model = "+cm);
	int awidth = bufA.getWidth();
	int aheight = bufA.getHeight();
	System.out.println("Alpha width = "+awidth+" ,Alpha height = "+aheight);
	
	WritableRaster wrA = bufA.getRaster();
	DataBuffer dbA = wrA.getDataBuffer();
	int[] arrayA = ((DataBufferInt)dbA).getData(); 
	
	
	//create RGBA TEXTURE
	
	int width = fwidth;
	int height = fheight;

  ColorSpace cs = ColorSpace.getInstance(ColorSpace.CS_sRGB); 
  int[] nBits = {8, 8, 8, 8}; 
  ComponentColorModel colorModel =
          new ComponentColorModel(cs, nBits, true, true, Transparency.TRANSLUCENT, 0); 
          
  WritableRaster raster = colorModel.createCompatibleWritableRaster(width, height); 
	BufferedImage bImage = new BufferedImage(colorModel, raster, false, null); 
 
  byte[] byteData = ((DataBufferByte)raster.getDataBuffer()).getData(); 
  System.out.println("byteData size = "+byteData.length);
 	
	for(int i=0; i<array.length;i++){
		
		//RGB components
		int pixel	= array[i];
		int red 	= cm.getRed(pixel);
		int green = cm.getGreen(pixel);
		int blue 	= cm.getBlue(pixel);
		//int alpha = cm.getAlpha(pixel);
		//alpha mask
		int pixelA	= arrayA[i];
		int redA 	= cmA.getRed(pixelA);
		int greenA = cmA.getGreen(pixelA);
		int blueA 	= cmA.getBlue(pixelA);
		
		double lum = Math.sqrt(((float)(redA*redA + greenA*greenA + blueA*blueA))/(float)d);
		
		//linear relation between luminance of the alpha mask and the alpha value
		int alph = (int)(lum*255); 

		//System.out.println("RGBA = "+red+" ,"+green+" ,"+blue+" ,lum = "+lum+" ,alpha ="+alph);
		int k = i*4;
		byteData[k] = (byte)red;
		byteData[k+1] = (byte)green;
		byteData[k+2] = (byte)blue;
		byteData[k+3] = (byte)alph;



		
	}
	
	
	ImageComponent2D pArray = new ImageComponent2D(
		ImageComponent.FORMAT_RGBA, width, height);

	pArray.set(bImage);

	Texture2D tex = new Texture2D(Texture.BASE_LEVEL,
					   Texture.RGBA, width, height);
	tex.setImage(0, pArray);
	tex.setEnable(true);
	tex.setMinFilter(Texture.NICEST);
	tex.setMagFilter(Texture.NICEST);	
	
	tex.setMipMapMode(Texture.BASE_LEVEL);
	
	
	System.out.println("array size = "+array.length);
	System.out.println("data type = "+db.getDataType());
	
	System.out.println("TYPE_BYTE = "+DataBuffer.TYPE_BYTE);
  System.out.println("TYPE_DOUBLE = "+DataBuffer.TYPE_DOUBLE);
  System.out.println("TYPE_FLOAT = "+DataBuffer.TYPE_FLOAT);
  System.out.println("TYPE_INT = "+DataBuffer.TYPE_INT);
  System.out.println("TYPE_SHORT = "+DataBuffer.TYPE_SHORT);
  System.out.println("TYPE_UNDEFINED = "+DataBuffer.TYPE_UNDEFINED);
  System.out.println("TYPE_USHORT = "+DataBuffer.TYPE_USHORT);
       
  System.out.println("data bank number = "+db.getNumBanks() );
	System.out.println("data size = "+db.getSize() );

	//byte[] byteData = ((DataBufferByte)wr.getDataBuffer()).getData(); 
  //      System.out.println("byteData size = "+byteData.length);

 	//Image flame1 = Toolkit.getDefaultToolkit().getImage("flame1.jpg");
	//BufferedImage bflame1 = (BufferedImage) flame1;
	//Button button = new Button();
	//int fwidth = flame1.getWidth(button);
	//int fheight = flame1.getHeight(button);
	//System.out.println("flame width = "+fwidth+" ,flame height = "+fheight);
	//Graphics graph = flame1.createGraphics();
 	
 	// Create the root of the branch graph
	BranchGroup objRoot = new BranchGroup();

	// Create the transform group node and initialize it to the identity.
	// Enable the TRANSFORM_WRITE capability so that our behavior code
	// can modify it at runtime.  Add it to the root of the subgraph.
	
	TransformGroup objTrans = new TransformGroup();
	objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	objRoot.addChild(objTrans);


	TransformGroup objTrans2 = new TransformGroup();
	objTrans2.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	//objRoot.addChild(objTrans);

	//
	// Create some simple geometry (without an appearance node).
	// Create a new shape leaf node using the specified geometry
	// and add it into the scene graph.
	//
	

	//Texture2D tex1 = generateTexture (255, 0,0);
	//Texture2D tex2 = generateTexture (0, 0,255);


	// Create a simple shape leaf node
	
	
	
	
	
	
	
	float w = 1.6f*fwidth/256;
	float h = 1.6f*fheight/256;
	//create shape
	float[] vertices = {	-w,-h,0.0f,
												w,-h,0.0f,
												-w,h,0.0f,
													w,h,0.0f
										};
														
		int[] vertice_indices = {	0,3,2,
														0,1,3
														};
		
		 
		
		float[] texture_coord = {	0.0f, 0.0f,
															1.0f, 0.0f,
															1.0f, 1.0f,
															0.0f, 1.0f};
															
		int[] texture_coord_indices = { 0,2,3,
																		0,1,2
																			};
	
		
		
		GeometryInfo gi = new GeometryInfo(GeometryInfo.TRIANGLE_ARRAY);
		gi.setCoordinates(vertices);
		gi.setCoordinateIndices(vertice_indices);
		//gi.setColors(colors);
		//gi.setColorIndices(color_indices);
		gi.setTextureCoordinates2(texture_coord);
		gi.setTextureCoordinateIndices(texture_coord_indices);
		
		NormalGenerator ng = new NormalGenerator();
		ng.generateNormals(gi);
		
		Stripifier st = new Stripifier();
		st.stripify(gi);
		
		
		Point3f[] verts = gi.getCoordinates();
		for (int i=0;i<verts.length;i++){
			System.out.println("vertices["+i+"] = "+verts[i]);
		}
		int[] verts_indices = gi.getCoordinateIndices();
		for (int i=0;i<verts_indices.length;i++){
			System.out.println("vertices indices["+i+"] = "+verts_indices[i]);
		}
		//Color3f[] colrs = (Color3f[]) gi.getColors();
		//for (int i=0;i<colrs.length;i++){
		//	System.out.println("colors["+i+"] = "+colrs[i]);
		//}
		//int[] colrs_indices = gi.getColorIndices();
		//for (int i=0;i<colrs_indices.length;i++){
		//	System.out.println("color indices["+i+"] = "+colrs_indices[i]);
		//}
		Vector3f[] norms = gi.getNormals();
		for (int i=0;i<norms.length;i++){
			System.out.println("normals["+i+"] = "+norms[i]);
		}
	
		int[] norm_indices = gi.getNormalIndices();
		for (int i=0;i<norm_indices.length;i++){
			System.out.println("normal indices["+i+"] = "+norm_indices[i]);
		}
		
		int[] strip_counts = gi.getStripCounts();
		for (int i=0;i<strip_counts.length;i++){
			System.out.println("strip counts["+i+"] = "+strip_counts[i]);
		}
		
		Point2f[] texes = (Point2f[])gi.getTextureCoordinates();
		//int[] tex_indices = gi.getTextureCoordinateIndices();

		for (int i=0;i<texes.length;i++){
			System.out.println("textures coord["+i+"] = "+texes[i]);
		}

		
		int[] tex_indices = gi.getTextureCoordinateIndices();
		for (int i=0;i<tex_indices.length;i++){
			System.out.println("textures indices["+i+"] = "+tex_indices[i]);
		}

		

	
		GeometryArray geometry_array = gi.getGeometryArray();
		
		ShapeConstructor constructor = 
							new ShapeConstructor(	verts, verts_indices, 
																		norms, norm_indices,
																		//colrs, colrs_indices,
																		texes, tex_indices,
																		strip_counts);
																														
		Shape3D rect_shape = constructor.getShape();
		rect_shape.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		
	
	//float w = 1.6f*fwidth/256;
	//float h = 1.6f*fheight/256;
	//create shape
	float[] vertices2 = {	-w,-h,0.0f,
												w,-h,0.0f,
												-w,h,0.0f,
													w,h,0.0f
										};
														
		int[] vertice_indices2 = {	0,3,2,
														0,1,3
														};
		
		 
		
		float[] texture_coord2 = {	0.0f, 0.0f,
															1.0f, 0.0f,
															1.0f, 1.0f,
															0.0f, 1.0f};
															
		int[] texture_coord_indices2 = { 0,2,3,
																		0,1,2
																			};
	
		
		
		GeometryInfo gi2 = new GeometryInfo(GeometryInfo.TRIANGLE_ARRAY);
		gi2.setCoordinates(vertices2);
		gi2.setCoordinateIndices(vertice_indices2);
		//gi.setColors(colors);
		//gi.setColorIndices(color_indices);
		gi2.setTextureCoordinates2(texture_coord2);
		gi2.setTextureCoordinateIndices(texture_coord_indices2);
		
		NormalGenerator ng2 = new NormalGenerator();
		ng2.generateNormals(gi2);
		
		Stripifier st2 = new Stripifier();
		st2.stripify(gi2);
		
		
		Point3f[] verts2 = gi2.getCoordinates();
		for (int i=0;i<verts2.length;i++){
			System.out.println("vertices["+i+"] = "+verts2[i]);
		}
		int[] verts_indices2 = gi2.getCoordinateIndices();
		for (int i=0;i<verts_indices2.length;i++){
			System.out.println("vertices indices["+i+"] = "+verts_indices2[i]);
		}
		//Color3f[] colrs = (Color3f[]) gi.getColors();
		//for (int i=0;i<colrs.length;i++){
		//	System.out.println("colors["+i+"] = "+colrs[i]);
		//}
		//int[] colrs_indices = gi.getColorIndices();
		//for (int i=0;i<colrs_indices.length;i++){
		//	System.out.println("color indices["+i+"] = "+colrs_indices[i]);
		//}
		Vector3f[] norms2 = gi2.getNormals();
		for (int i=0;i<norms2.length;i++){
			System.out.println("normals["+i+"] = "+norms2[i]);
		}
	
		int[] norm_indices2 = gi2.getNormalIndices();
		for (int i=0;i<norm_indices2.length;i++){
			System.out.println("normal indices["+i+"] = "+norm_indices2[i]);
		}
		
		int[] strip_counts2 = gi2.getStripCounts();
		for (int i=0;i<strip_counts2.length;i++){
			System.out.println("strip counts["+i+"] = "+strip_counts2[i]);
		}
		
		Point2f[] texes2 = (Point2f[])gi2.getTextureCoordinates();
		//int[] tex_indices = gi.getTextureCoordinateIndices();

		for (int i=0;i<texes2.length;i++){
			System.out.println("textures coord["+i+"] = "+texes2[i]);
		}

		
		int[] tex_indices2 = gi2.getTextureCoordinateIndices();
		for (int i=0;i<tex_indices2.length;i++){
			System.out.println("textures indices["+i+"] = "+tex_indices2[i]);
		}

		
		ShapeConstructor constructor2 = 
							new ShapeConstructor(	verts2, verts_indices2, 
																		norms2, norm_indices2,
																		//colrs, colrs_indices,
																		texes2, tex_indices2,
																		strip_counts2);
																														
		Shape3D rect_shape2 = constructor.getShape();
		rect_shape2.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
	
	
	Appearance a1 = new Appearance();
	 	TextureAttributes textatt = new TextureAttributes();
	//textatt.setTextureMode(TextureAttributes.MODULATE);
	//a.setTextureAttributes(textatt);
	BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
	
	TransparencyAttributes transp = new TransparencyAttributes();
	transp.setTransparencyMode(TransparencyAttributes.BLENDED);
	a1.setTransparencyAttributes(transp);
	 	
	Material mat = new Material();
	//a1.setMaterial(mat);
	 	a1.setTexture(tex);
	 
	//TransformGroup objTrans = new TransformGroup();
	//objTransf.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
  rect_shape.setAppearance(a1);
  rect_shape2.setAppearance(a1);
  //objRoot.addChild(objTransf);
  objTrans.addChild(rect_shape);
	TransformGroup back = new TransformGroup();
	Transform3D gb = new Transform3D();
	gb.rotY(Math.PI);
	back.setTransform(gb);
	objTrans.addChild(back);
	back.addChild(rect_shape2);
	
 
	

	AmbientLight aLgt = new AmbientLight(alColor);
	aLgt.setInfluencingBounds(bounds);
	DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
	lgt1.setInfluencingBounds(bounds);
	DirectionalLight lgt2 = new DirectionalLight(lColor2, lDir2);
	lgt2.setInfluencingBounds(bounds);
	objRoot.addChild(aLgt);
	objRoot.addChild(lgt1);
	//objTrans.addChild(lgt2);
	
	Grid grid = new Grid (100,0.25f,new Color3f(0.0f,1.0f,0.0f));
	TransformGroup trans = new TransformGroup();
	Transform3D tr = new Transform3D();
	tr.setTranslation(new Vector3f(0.0f,0.0f,-10.0f));
	trans.setTransform(tr);
	objRoot.addChild(trans);
	
	TransformGroup gridtf = new TransformGroup();
	Transform3D gt = new Transform3D();
	gt.rotX(Math.PI/2);
	gridtf.setTransform(gt);
	trans.addChild(gridtf);
	gridtf.addChild(grid);
	
	
	Color3f grey = new Color3f(0.0f, 0.0f, 0.0f);
  Background bg = new Background(grey);
  bg.setApplicationBounds(bounds);
  objRoot.addChild(bg);


	//
	// Create a new Behavior object that will perform the desired
	// operation on the specified transform object and add it into the
	// scene graph.
	//
	Transform3D yAxis = new Transform3D();
	Alpha rotorAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE,
				     0, 0,
				     4000, 0, 0,
				     0, 0, 0);
	RotationInterpolator rotator =
	    new RotationInterpolator(rotorAlpha,
				     objTrans,
				     yAxis,
				     0.0f, (float) Math.PI*2.0f);
	rotator.setSchedulingBounds(bounds);
	objTrans.addChild(rotator);

        // Have Java 3D perform optimizations on this scene graph.
        objRoot.compile();

	return objRoot;
    }
	//========================================================
    public Transparent(String RGB_file, String alpha_file) {
  //========================================================
	setLayout(new BorderLayout());
	Canvas3D c = new Canvas3D(null);
	add("Center", c);



	
	// Create a simple scene and attach it to the virtual universe
	BranchGroup scene = createSceneGraph(RGB_file, alpha_file);
	SimpleUniverse u = new SimpleUniverse(c);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
	u.getViewingPlatform().setNominalViewingTransform();

	u.addBranchGraph(scene);
    }

    //
    // The following allows TextureTest to be run as an application
    // as well as an applet
    //
  //======================================
  public static void main(String[] args) {
  //======================================
  	Transparent ft = new Transparent(args[0], args[1]);
  	
  	for (int i=0; i< 100;i++){
  		
  		System.out.println("lum = "+(((float)i)/100)+" alph = "+ft.LumToAlpha((double)((float)i)/100));
  		
  	}
	new MainFrame(ft, 256, 256);
    }

}