/////////////////////////////////////////////////////
//
//        Color and Lighting test ...
//
//				How to enable lighting when using the colors defined 
//				in the Geometry ?
//				Setting an appearance with a default Material enables
//				lighting but overrides the colors defined in the geometry ...
//        Is it possible to have ligthing and different colors
//        at the same time on a Shape3D ??
//        If not, whats the point of defining colors in the geometry ?
//
//          press ** SPACE ** to switch between 
//          Appearance with null Material (geometry colors appear)
//          and Appearance with default Material
//					
//
/////////////////////////////////////////////////////////


import com.sun.j3d.utils.geometry.*;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.awt.GraphicsConfiguration;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.*;
import javax.media.j3d.*;
import javax.vecmath.*;

public class HelloUniverse extends Applet implements KeyListener{
  
  
  boolean pressed = false;
  Shape3D shape;
  
  //=====================================
  public BranchGroup createSceneGraph() {
  //=====================================
		// Create the root of the branch graph
		BranchGroup objRoot = new BranchGroup();
	
		// Create the transform group node and initialize it to the
		// identity.  Enable the TRANSFORM_WRITE capability so that
		// our behavior code can modify it at runtime.  Add it to the
		// root of the subgraph.
		
		// Create the bounding leaf node
	  
	  
	     
	  AppearanceSet appearanceSet = new AppearanceSet();
	  BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 200.0);
	  
	  Color3f red = new Color3f(1.0f,0.0f,0.0f);
		Color3f green = new Color3f(0.0f,1.0f,0.0f);
		Color3f blue = new Color3f(0.0f,0.0f,1.0f);
		Color3f yellow = new Color3f(1.0f,1.0f,0.0f);
		Color3f white = new Color3f(1.0f,1.0f,1.0f);                                               
	      
	  // Create the ambient light
//	  AmbientLight ambLight = new AmbientLight(white);
//	  ambLight.setInfluencingBounds(bounds);
//	  objRoot.addChild(ambLight);
	  
//	  Vector3f dir = new Vector3f(0f, 0f, -1.0f);
//	  DirectionalLight dirLight = new DirectionalLight(white, dir);
//	  dirLight.setInfluencingBounds(bounds);
//	  objRoot.addChild(dirLight);
	  
	  Color3f lColor2 = new Color3f(1f, 1f, 1f);
    PointLight lgt2 = new PointLight(lColor2, new Point3f(0f, 0f, 1f), new Point3f(0.25f, 0.1f, 0.01f));
    lgt2.setInfluencingBounds(new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
    objRoot.addChild(lgt2);

	      
	
		
		
		TransformGroup scaleBack = new TransformGroup();
		
		Matrix4d mat_init = new  Matrix4d (  1.0,   0.0                ,  0.0                , 0.0,
	                                       0.0,   Math.cos(Math.PI/6), -Math.sin(Math.PI/6), 0.0,
	                                       0.0,   Math.sin(Math.PI/6),  Math.cos(Math.PI/6), -10.0,
	                                       0.0,   0.0                ,  0.0                , 1.0);
	                                                 
	  Transform3D t1 = new Transform3D(mat_init);
	  t1.normalize();
	  scaleBack.setTransform(t1);
	
		
		TransformGroup objTrans = new TransformGroup();
		objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objRoot.addChild(scaleBack);
		scaleBack.addChild(objTrans);
		 		
		
		
		Shape3D object = new Shape3D();
		
		 	
		
		float[] vertices = {	-3.0f,0.0f,-2.0f,
													0.0f,0.0f,4.0f,
													3.0f,0.0f,-2.0f,
													0.0f,4.0f,0.0f};
		int[] vertice_indices = {	0,3,1,
															1,3,2,
															0,2,3,															
															1,2,0};
		
		
	
		Color3f[] colors = {red, green, blue, yellow};
		int [] color_indices = {0,0,0,
														1,1,1,
														2,2,2,
														3,3,3};
		
		GeometryInfo gi = new GeometryInfo(GeometryInfo.TRIANGLE_ARRAY);
		gi.setCoordinates(vertices);
		gi.setCoordinateIndices(vertice_indices);
		gi.setColors(colors);
		gi.setColorIndices(color_indices);
	
		
		NormalGenerator ng = new NormalGenerator();
		ng.generateNormals(gi);
		
		Stripifier st = new Stripifier();
		st.stripify(gi);
		
		
		Point3f[] verts = gi.getCoordinates();
		for (int i=0;i<verts.length;i++){
			System.out.println("vertices["+i+"] = "+verts[i]);
		}
		int[] verts_indices = gi.getCoordinateIndices();
		for (int i=0;i<verts_indices.length;i++){
			System.out.println("vertices indices["+i+"] = "+verts_indices[i]);
		}
		Color3f[] colrs = (Color3f[]) gi.getColors();
		for (int i=0;i<colrs.length;i++){
			System.out.println("colors["+i+"] = "+colrs[i]);
		}
		int[] colrs_indices = gi.getColorIndices();
		for (int i=0;i<colrs_indices.length;i++){
			System.out.println("color indices["+i+"] = "+colrs_indices[i]);
		}
		Vector3f[] norms = gi.getNormals();
		for (int i=0;i<norms.length;i++){
			System.out.println("normals["+i+"] = "+norms[i]);
		}
	
		int[] norm_indices = gi.getNormalIndices();
		for (int i=0;i<norm_indices.length;i++){
			System.out.println("normal indices["+i+"] = "+norm_indices[i]);
		}
		
		int[] strip_counts = gi.getStripCounts();
		for (int i=0;i<strip_counts.length;i++){
			System.out.println("strip counts["+i+"] = "+strip_counts[i]);
		}
	
	
		

	
		GeometryArray geometry_array = gi.getGeometryArray();
		
		ShapeConstructor constructor = 
							new ShapeConstructor(	verts, verts_indices, 
																		norms, norm_indices,
																		colrs, colrs_indices,
																		strip_counts);
																														
		shape = constructor.getShape();
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		
		//SET AN APPEARANCE WITH DEFAULT MATERIAL - DISABLE THE GEOMETRY COLORS
		Appearance app = new Appearance();
		Material mat = new Material();
		app.setMaterial(mat);
		
		//shape.setAppearance(appearanceSet.whiteAppearance);
		shape.setAppearance(app);
		
		//objTrans.addChild(new ColorCube(0.4));
		objTrans.addChild(shape);
	
		// Create a new Behavior object that will perform the desired
		// operation on the specified transform object and add it into
		// the scene graph.
		Transform3D yAxis = new Transform3D();
		Alpha rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE,
						0, 0,
						4000, 0, 0,
						0, 0, 0);
	
		RotationInterpolator rotator =
		    new RotationInterpolator(rotationAlpha, objTrans, yAxis,
					     0.0f, (float) Math.PI*2.0f);
		rotator.setSchedulingBounds(bounds);
		objTrans.addChild(rotator);
	
	        // Have Java 3D perform optimizations on this scene graph.
	        objRoot.compile();
		System.out.println("!!!!PRESS *SPACE*!!!!!!");
		return objRoot;
	    }
	//======================
  public HelloUniverse() {
  //======================
	setLayout(new BorderLayout());
        GraphicsConfiguration config =
           SimpleUniverse.getPreferredConfiguration();

	Canvas3D c = new Canvas3D(config);
	add("Center", c);
	c.addKeyListener(this);
	// Create a simple scene and attach it to the virtual universe
	BranchGroup scene = createSceneGraph();
	SimpleUniverse u = new SimpleUniverse(c);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        u.getViewingPlatform().setNominalViewingTransform();

	u.addBranchGraph(scene);
    }

    //
    // The following allows HelloUniverse to be run as an application
    // as well as an applet
    //
  
  //======================================   
  public static void main(String[] args) {
  //====================================== 
  
	new MainFrame(new HelloUniverse(), 256, 256);
  }
    
  //==================================  
  public void keyPressed(KeyEvent e) {
  //==================================	
  //	System.out.println("Key pressed");

  	if (e.getKeyCode() == KeyEvent.VK_SPACE) {
  		//System.out.println("Space pressed");
  		Appearance app = new Appearance();
  		if (pressed){
  			//DEFAULT MATERIAL -> DISABLE GEOMETRY COLORS, BUT LIGHTING
				Material mat = new Material();
				app.setMaterial(mat);
				System.out.println("No Colors :(  ... !! Lighting !! :)");

  		}
  		else{
  			System.out.println("Colors :)  ... !! No Lighting !! :(");	
  		}
  		//NULL MATERIAL -> ENBALE GEOMETRY COLORS, BUT NO LIGHTING
  		
			shape.setAppearance(app);
			
			pressed = !pressed;
  	}

  	
  }
  public void keyReleased(KeyEvent e) {
  	
  }
  public void keyTyped(KeyEvent e) {
                 
  }
    
    
}