/*
//*****************************************************************************
/*
*	@(#) Appearance_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;
import javax.media.j3d.*;

public class Appearance_Info extends ObjectInfo
{

	private static final int[] 		m_kCapabilityArray = 
												{
													Appearance.ALLOW_COLORING_ATTRIBUTES_READ,
													Appearance.ALLOW_LINE_ATTRIBUTES_READ,
													Appearance.ALLOW_COLORING_ATTRIBUTES_READ,
													Appearance.ALLOW_MATERIAL_READ,
													Appearance.ALLOW_POINT_ATTRIBUTES_READ,
													Appearance.ALLOW_POLYGON_ATTRIBUTES_READ,
													Appearance.ALLOW_RENDERING_ATTRIBUTES_READ,
													Appearance.ALLOW_TEXGEN_READ,
													Appearance.ALLOW_TEXTURE_ATTRIBUTES_READ,
													Appearance.ALLOW_TEXTURE_READ,
													Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_READ
												};

	public Appearance_Info()
	{
	}
	
	java.util.Enumeration getChildren( Object obj )
	{
		java.util.Vector v = new java.util.Vector();
		
		Appearance app = (Appearance) obj;
		
		if( app.getColoringAttributes() != null )
			v.addElement( app.getColoringAttributes() );
		
		if( app.getLineAttributes() != null )
			v.addElement( app.getLineAttributes() );
		
		if( app.getMaterial() != null )
			v.addElement( app.getMaterial() );
		
		if( app.getPolygonAttributes() != null )
			v.addElement( app.getPolygonAttributes() );
		
		if( app.getRenderingAttributes() != null )
			v.addElement( app.getRenderingAttributes() );
		
		if( app.getTexCoordGeneration() != null )
			v.addElement( app.getTexCoordGeneration() );
		
		if( app.getTexture() != null )
			v.addElement( app.getTexture() );
		
		if( app.getTextureAttributes() != null )
			v.addElement( app.getTextureAttributes() );
		
		if( app.getTransparencyAttributes() != null )
			v.addElement( app.getTransparencyAttributes() );
		
		return createCompoundEnumeration( v, super.getChildren( obj ) );
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{
		String szText = super.getInfo( obj );

		szText = insertSectionBreak( szText );
		szText += "Apperance\r\n";
				
		return szText;
	}
}