/*
//*****************************************************************************
/*
*	@(#) Background_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;

import javax.media.j3d.*;
import javax.vecmath.*;

public class Background_Info extends Leaf_Info
{
	private static final int[] 		m_kCapabilityArray = {	
																				Background.ALLOW_APPLICATION_BOUNDS_READ,
																				Background.ALLOW_COLOR_READ,
																				Background.ALLOW_GEOMETRY_READ,
																				Background.ALLOW_IMAGE_READ
																			};

	public Background_Info()
	{
	}
	
	java.util.Enumeration getChildren( Object obj )
	{
		if( ((Background) obj).getGeometry() != null )
			return createCompoundEnumeration( super.getChildren( obj ), ((Background) obj).getGeometry() );
		else
			return super.getChildren( obj );
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{
		Background back = (Background ) obj;
			
		String szText = super.getInfo( obj );
		szText = insertSectionBreak( szText );
		
		szText += "Background\r\n";
		szText += "Application Bounding Leaf: " + back.getApplicationBoundingLeaf() + "\r\n";
		szText += "Application Bounds: " + back.getApplicationBounds() + "\r\n";
		
		Color3f color = new Color3f();
		back.getColor( color ); 
		szText += "Color: " + color + "\r\n";
		szText += "ImageComponent2D: " + back.getImage() + "\r\n";

		return szText;
	}
}