/*
//*****************************************************************************
/*
*	@(#) DirectionalLight_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;

import javax.media.j3d.*;
import javax.vecmath.*;


public class DirectionalLight_Info extends Light_Info
{
	private static final int[] 		m_kCapabilityArray = { 	
																				DirectionalLight.ALLOW_DIRECTION_READ
																			};

	public DirectionalLight_Info()
	{
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{			
		String szText = super.getInfo( obj );
		szText = insertSectionBreak( szText );
		
		szText += "DirectionalLight\r\n";
		
		DirectionalLight directionalLight = (DirectionalLight) obj;
		
		Vector3f direction = new Vector3f();
		directionalLight.getDirection( direction );
		
		szText += "Direction: " + direction + "\r\n";
		
		return szText;
	}
}