/*
//*****************************************************************************
/*
*	@(#) Group_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;
import javax.media.j3d.*;

public class Group_Info extends Node_Info
{
	private static final int[] 		m_kCapabilityArray = { 	
																				Group.ALLOW_CHILDREN_READ, 
																				Group.ALLOW_COLLISION_BOUNDS_READ
																			};

	public Group_Info()
	{
	}
		
	java.util.Enumeration getChildren( Object obj )
	{
		return createCompoundEnumeration( super.getChildren( obj ), ((Group) obj).getAllChildren() );
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{
		Group group = (Group) obj;
			
		String szText = super.getInfo( obj );
		szText = insertSectionBreak( szText );
		
		szText += "Group\r\n";
		szText += "NumChildren: " + group.numChildren() + "\r\n";
		szText += "CollisionBounds: " + group.getCollisionBounds() + "\r\n";
		
		return szText;
	}
}