/*
//*****************************************************************************
/*
*	@(#) Light_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;

import javax.media.j3d.*;
import javax.vecmath.*;


public class Light_Info extends Leaf_Info
{
	private static final int[] 		m_kCapabilityArray = { 	
																				Light.ALLOW_COLOR_READ, 
																				Light.ALLOW_INFLUENCING_BOUNDS_READ,
																				Light.ALLOW_SCOPE_READ,
																				Light.ALLOW_STATE_READ
																			};

	public Light_Info()
	{
	}
	
	java.util.Enumeration getChildren( Object obj )
	{
		// add the Bounding Leaf as a child object
		Light light = (Light) obj;
		return createCompoundEnumeration( super.getChildren( obj ), light.getInfluencingBoundingLeaf() );
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{
		Light light = (Light) obj;
			
		String szText = super.getInfo( obj );
		szText = insertSectionBreak( szText );
		
		szText += "Light\r\n";
		
		Color3f color = new Color3f();
		light.getColor( color );
		szText += "Color: " + color + "\r\n";
		szText += "Enable: " + light.getEnable() + "\r\n";
		szText += "Influencing Bounds: " + light.getInfluencingBounds() + "\r\n";
		
		try
		{
			szText += "Number of Scopes: " + light.numScopes() + "\r\n";
			
			java.util.Enumeration enumScopes = light.getAllScopes();
			
			if( enumScopes != null )
			{
				while( enumScopes.hasMoreElements() == true )
					szText += "  Group: " + enumScopes.nextElement() + "\r\n";
			}
			else
				System.err.println( "Warning. Scope for Light is null" );
		}
		catch( Exception e )
		{
			System.err.println( "Warning. Unable to read Scope for Light" );
		}
		
		return szText;
	}
}