/*
//*****************************************************************************
/*
*	@(#) Group_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;
import javax.media.j3d.*;

public class Node_Info extends SceneGraphObject_Info
{
	private static final int[] 		m_kCapabilityArray = { 	
																				Node.ALLOW_AUTO_COMPUTE_BOUNDS_READ, 
																				Node.ALLOW_BOUNDS_READ,
																				Node.ALLOW_COLLIDABLE_READ,
																				Node.ALLOW_LOCAL_TO_VWORLD_READ,
																				Node.ALLOW_PICKABLE_READ
																			};

	public Node_Info()
	{
	}
		
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{
		Node node = (Node) obj;
			
		String szText = super.getInfo( obj );
		szText = insertSectionBreak( szText );
		
		szText += "Node\r\n";
		szText += "BoundsAutoCompute: " + node.getBoundsAutoCompute() + "\r\n";
		szText += "Collidable: " + node.getCollidable() + "\r\n";
		szText += "Pickable: " + node.getPickable() + "\r\n";
		szText += "Bounds: " + node.getBounds() + "\r\n";
		
		try
		{
			szText += "Parent: " + node.getParent() + "\r\n";
		}
		catch( Exception e )
		{
		}
		
		return szText;
	}
}