/*
//*****************************************************************************
/*
*	@(#) ObjectInfo.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;

import javax.media.j3d.*;
import javax.vecmath.*;

import com.sun.j3d.utils.universe.*;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class ObjectInfo
{
	public ObjectInfo()
	{
	}
	
	public String insertSectionBreak( String szText )
	{
		return (szText + "\r\n==============================\r\n");
	}
	
	public int[] getCapabilityBits()
	{
		return null;
	}
	
	private java.util.Enumeration getChildrenHelper( Object obj )
	{
		java.util.Enumeration enum = null;

		try
		{
			enum = getChildren( obj );
		}
		catch( Exception e )
		{
			System.err.println( e.toString() );
		}
		
		return enum;
	}
	
	public void setCapabilityBits( Java3dTree j3dTree, Object obj )
	{
		int[] nBitsArray = getCapabilityBits();
		
		if( nBitsArray != null && obj instanceof SceneGraphObject )
		{
			for( int n = 0; n < nBitsArray.length; n++ )
				((SceneGraphObject) obj).setCapability( nBitsArray[n] );
		}
		
		java.util.Enumeration enum = getChildrenHelper( obj );
		
		if( enum != null )
		{
			while( enum.hasMoreElements() == true ) 
				j3dTree.recursiveApplyCapability( enum.nextElement() );
		}
	}
	
	java.util.Enumeration getChildren( Object obj )
	{
		return null;
	}
	
	// Vector + Enum
	java.util.Enumeration createCompoundEnumeration( java.util.Vector v, java.util.Enumeration enum )
	{
		if( enum != null )
		{
			while( enum.hasMoreElements() == true && v != null )
				v.addElement( enum.nextElement() );
		}
		
		if( v != null)
			return v.elements();
		else 
			return enum;
	}
	
	// Vector + Vector
	java.util.Enumeration createCompoundEnumeration( java.util.Vector v1, java.util.Vector v2 )
	{
		return createCompoundEnumeration( v1, v2.elements() );
	}
	
	// Enum + Enum
	java.util.Enumeration createCompoundEnumeration( java.util.Enumeration enum1, java.util.Enumeration enum2 )
	{
		java.util.Vector v = new java.util.Vector();
		
		while( enum1 != null && enum1.hasMoreElements() == true )
			v.addElement( enum1.nextElement() );
		
		return createCompoundEnumeration( v, enum2 );
	}
	
	// Enum + Object
	java.util.Enumeration createCompoundEnumeration( java.util.Enumeration enum1, Object obj )
	{
		java.util.Vector v = new java.util.Vector();
		v.addElement( obj );
		
		while( enum1 != null && enum1.hasMoreElements() == true )
			v.addElement( enum1.nextElement() );
		
		return v.elements();
	}

	
	int[] createCompoundArray( int[] a1, int[] a2 )
	{
		int[] aRet = null;
		int nTotalLen = 0;
		int nLen1 = 0;
		int nLen2 = 0;
		
		if( a1 != null )
		{
			nTotalLen += a1.length;
			nLen1 = a1.length;
		}
		
		if( a2 != null )
		{
			nTotalLen += a2.length;
			nLen2 = a2.length;
		}
		
		aRet = new int[ nTotalLen ];
		
		if( a1 != null )
			System.arraycopy( a1, 0, aRet, 0, nLen1 );
		
		if( a2 != null )
			System.arraycopy( a2, 0, aRet, nLen1, a2.length );
		
		return aRet;
	}
	
	public void addToTree( Java3dTree j3dTree, DefaultMutableTreeNode parent, Object obj )
	{
		DefaultMutableTreeNode node = new DefaultMutableTreeNode( obj );
		parent.add( node );

		java.util.Enumeration enum = getChildrenHelper( obj );
		
		if( enum != null )
		{
			while( enum.hasMoreElements() == true ) 
			{
				j3dTree.recurseObject( enum.nextElement(), node );
			}
		}
	}
	
	public String getInfo( Object obj )
	{
		String szText = "";
		szText = insertSectionBreak( szText );
		
		szText += "Object\r\n";
		return (szText + "Type: " + obj.toString() + "\r\n" );
	}
}