/*
//*****************************************************************************
/*
*	@(#) PointLight_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;

import javax.media.j3d.*;
import javax.vecmath.*;


public class PointLight_Info extends Light_Info
{
	private static final int[] 		m_kCapabilityArray = { 	
																				PointLight.ALLOW_ATTENUATION_READ,																				
																				PointLight.ALLOW_POSITION_READ
																			};

	public PointLight_Info()
	{
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{			
		String szText = super.getInfo( obj );
		szText = insertSectionBreak( szText );
		
		szText += "PointLight\r\n";
		
		PointLight pointLight = (PointLight) obj;
		
		Point3f attenuation = new Point3f();
		pointLight.getAttenuation( attenuation );
		szText += "Attenuation: " + attenuation + "\r\n";
		
		Point3f position = new Point3f();
		pointLight.getPosition( position );
		szText += "Position: " + position + "\r\n";

		return szText;
	}
}