/*
//*****************************************************************************
/*
*	@(#) Shape3D_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;
import javax.media.j3d.*;

public class Shape3D_Info extends Leaf_Info
{
	private static final int[] 		m_kCapabilityArray = { 	
																				Shape3D.ALLOW_APPEARANCE_READ,
																				Shape3D.ALLOW_COLLISION_BOUNDS_READ,
																				Shape3D.ALLOW_GEOMETRY_READ
																			};

	public Shape3D_Info()
	{
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	java.util.Enumeration getChildren( Object obj )
	{
		Shape3D shape = (Shape3D) obj;
		
		if( shape.getAppearance() != null )
			return createCompoundEnumeration( super.getChildren( obj ), shape.getAppearance() );
		else
			return super.getChildren( obj );
	}
	
	public String getInfo( Object obj )
	{
		String szText = super.getInfo( obj );

		szText = insertSectionBreak( szText );
		
		Shape3D shape = (Shape3D) obj;

		szText += "Shape3D\r\n";
		szText += "CollisionBounds: " + shape.getCollisionBounds() + "\r\n";
		szText += "Geometry: " + shape.getGeometry() + "\r\n";
		
		return szText;
	}
}