/*
//*****************************************************************************
/*
*	@(#) SpotLight_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;

import javax.media.j3d.*;
import javax.vecmath.*;


public class SpotLight_Info extends PointLight_Info
{
	private static final int[] 		m_kCapabilityArray = { 	
																				SpotLight.ALLOW_CONCENTRATION_READ,
																				SpotLight.ALLOW_DIRECTION_READ,
																				SpotLight.ALLOW_SPREAD_ANGLE_READ
																			};

	public SpotLight_Info()
	{
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{			
		String szText = super.getInfo( obj );
		szText = insertSectionBreak( szText );
		
		szText += "SpotLight\r\n";
		
		SpotLight spotLight = (SpotLight) obj;
		
		szText += "Concentration: " + spotLight.getConcentration() + "\r\n";

		Vector3f direction = new Vector3f();
		spotLight.getDirection( direction );
		szText += "Direction: " + direction + "\r\n";
		
		szText += "Spread Angle: " + spotLight.getSpreadAngle() + "\r\n";

		return szText;
	}
}