/*
//*****************************************************************************
/*
*	@(#) TransformGroup_Info.java
*
*	Project:		Java3dTree
*	Client:		Java 3D Community
*
*	Project Information:
*		dselman@tornadolabs.com
*		http://www.tornadolabs.com
*	
*	@author Daniel Selman: dselman@tornadolabs.com
*/
//*****************************************************************************

package com.tornadolabs.j3dtree;
import javax.media.j3d.*;

public class TransformGroup_Info extends Group_Info
{
	private static final int[] 		m_kCapabilityArray = { 	
																				TransformGroup.ALLOW_TRANSFORM_READ
																			};

	public TransformGroup_Info()
	{
	}
	
	public int[] getCapabilityBits()
	{
		return createCompoundArray( m_kCapabilityArray, super.getCapabilityBits() );
	}
	
	public String getInfo( Object obj )
	{
		String szText = super.getInfo( obj );

		szText = insertSectionBreak( szText );
		szText += "TransformGroup\r\n";
		
		Transform3D t3d = new Transform3D();
		TransformGroup tg = (TransformGroup) obj;
		tg.getTransform( t3d );
		szText += "Transform: ->\r\n";
		szText += t3d.toString() + "\r\n";
		
		return szText;
	}
}