/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.behavior.impl;

import java.util.Enumeration;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.j3de.behavior.MovementBehavior;
import org.j3de.util.ConfigHelper;
import org.j3de.util.Configurable;
import org.j3de.util.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultMovementBehavior
extends MovementBehavior
implements Configurable {
    private transient Transform3D moveTransform;
    private transient Transform3D sensorTransform;
    private transient TransformGroup transformGroup;
    private transient long timestamp;
    private transient WakeupOnElapsedFrames wakeup;
    private transient Vector3d translation;
    private transient Matrix3d rotationMatrix;
    private transient AxisAngle4d axisAngle;
    private double speedFactor = 5.0;
    private int frames = 0;
    private long frametimestamp = System.currentTimeMillis();
    protected transient ConfigHelper helper;

    public void configurationSaved() {
        this.helper.configurationSaved();
    }

    public Node configure(Document nodeFactory, String componentName) throws ConfigurationException {
        Element component = ConfigHelper.newComponent(nodeFactory, componentName, this);
        this.helper = new ConfigHelper(component, nodeFactory, true);
        this.configure(component, nodeFactory);
        return component;
    }

    public void configure(Node node, Document nodeFactory) throws ConfigurationException {
        if (this.helper == null) {
            this.helper = new ConfigHelper(node, nodeFactory, false);
        }
        this.speedFactor = this.helper.getPropertyValue("speedfactor", 1.0, true);
    }

    public void initialize() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        this.moveTransform = new Transform3D();
        this.sensorTransform = new Transform3D();
        this.translation = new Vector3d();
        this.axisAngle = new AxisAngle4d();
        this.rotationMatrix = new Matrix3d();
        this.wakeup = new WakeupOnElapsedFrames(0);
        this.wakeupOn((WakeupCondition)this.wakeup);
        this.timestamp = System.currentTimeMillis();
    }

    public boolean isConfigurationChanged() {
        return this.helper.isConfigurationChanged();
    }

    public void processStimulus(Enumeration criteria) {
        double scale = (double)(System.currentTimeMillis() - this.timestamp) / 1000.0;
        this.getSensor().getRead(this.sensorTransform);
        this.transformGroup.getTransform(this.moveTransform);
        this.sensorTransform.get(this.translation);
        this.sensorTransform.get(this.rotationMatrix);
        this.axisAngle.set(this.rotationMatrix);
        this.translation.scale(scale * this.speedFactor);
        this.sensorTransform.setTranslation(this.translation);
        if (this.axisAngle.angle != 0.0) {
            this.axisAngle.angle *= scale;
            this.sensorTransform.set(this.axisAngle);
        }
        this.moveTransform.mul(this.sensorTransform);
        this.transformGroup.setTransform(this.moveTransform);
        this.timestamp = System.currentTimeMillis();
        ++this.frames;
        if (this.frames >= 100) {
            System.out.println("fps : " + 100000.0 / (double)(this.timestamp - this.frametimestamp));
            this.frametimestamp = this.timestamp;
            this.frames = 0;
        }
        this.wakeupOn((WakeupCondition)this.wakeup);
    }

    public void setTransformGroup(TransformGroup group) {
        this.transformGroup = group;
    }
}

