/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.exception;

import java.security.Permission;
import org.j3de.exception.DefaultExceptionHandler;
import org.j3de.permission.ExceptionHandlerPermission;

public abstract class ExceptionHandler {
    public static boolean SHOW_WARNING = true;
    public static boolean HIDE_WARNING = false;
    private static ExceptionHandler exceptionHandler = null;

    public ExceptionHandler() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new ExceptionHandlerPermission("instantiate"));
        }
        exceptionHandler = this;
    }

    public static void handleException(Exception e) {
        if (exceptionHandler == null) {
            exceptionHandler = new DefaultExceptionHandler();
        }
        exceptionHandler.handleExceptionImpl(e);
    }

    protected abstract void handleExceptionImpl(Exception var1);

    public static void handleFatalException(Exception e) {
        if (exceptionHandler == null) {
            exceptionHandler = new DefaultExceptionHandler();
        }
        exceptionHandler.handleFatalExceptionImpl(e);
    }

    protected abstract void handleFatalExceptionImpl(Exception var1);

    public static void handleWarning(String msg) {
        if (exceptionHandler == null) {
            exceptionHandler = new DefaultExceptionHandler();
        }
        exceptionHandler.handleWarningImpl(msg);
    }

    protected abstract void handleWarningImpl(String var1);
}

