/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.input;

import java.util.List;
import java.util.Vector;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import org.j3de.input.ActivationManager;
import org.j3de.input.VirtualInputDevice;

public class InputDevices {
    private VirtualInputDevice[] vdevices;
    private Vector sensors;
    private int userHead;
    private int dominantHand;
    private int nonDominantHand;
    private int movementDevice;

    public InputDevices(List devices, ActivationManager activationManager, int userHead, int dominantHand, int nonDominantHand, int movementDevice) {
        this.vdevices = new VirtualInputDevice[devices.size()];
        this.sensors = new Vector();
        int i = 0;
        while (i < devices.size()) {
            this.vdevices[i] = new VirtualInputDevice((InputDevice)devices.get(i), activationManager);
            int j = 0;
            while (j < this.vdevices[i].getSensorCount()) {
                this.sensors.add(this.vdevices[i].getSensor(j));
                ++j;
            }
            ++i;
        }
        this.userHead = userHead;
        this.dominantHand = dominantHand;
        this.nonDominantHand = nonDominantHand;
        this.movementDevice = movementDevice;
    }

    public InputDevice getDevice(int index) {
        return this.vdevices[index];
    }

    public int getDeviceCount() {
        return this.vdevices.length;
    }

    public int getDominantHand() {
        return this.dominantHand;
    }

    public int getMovementSensor() {
        return this.movementDevice;
    }

    public int getNonDominantHand() {
        return this.nonDominantHand;
    }

    public Sensor getSensor(int i) {
        return (Sensor)this.sensors.get(i);
    }

    public int getSensorCount() {
        return this.sensors.size();
    }

    public int getUserHead() {
        return this.userHead;
    }
}

