/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.input;

import com.sun.j3d.utils.geometry.ColorCube;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JFrame;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.j3de.behavior.impl.DefaultMovementBehavior;
import org.j3de.input.HasBehavior;
import org.j3de.util.Configuration;

public class InputTest {
    private Configuration config;
    private PhysicalEnvironment env;

    public InputTest(String configPath) throws Exception {
        this.config = new Configuration(configPath);
        this.createWorld();
    }

    private Canvas3D createCanvas3D() {
        GraphicsConfigTemplate3D tmpl = new GraphicsConfigTemplate3D();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration config = device.getBestConfiguration((GraphicsConfigTemplate)tmpl);
        return new Canvas3D(config);
    }

    private View createView() {
        PhysicalBody body = new PhysicalBody();
        this.env = new PhysicalEnvironment();
        View view = new View();
        view.setPhysicalBody(body);
        view.setPhysicalEnvironment(this.env);
        return view;
    }

    private void createWorld() throws Exception {
        Canvas3D canvas3d = this.createCanvas3D();
        VirtualUniverse vr = new VirtualUniverse();
        View view = this.createView();
        Locale locale = new Locale(vr);
        BranchGroup world_object_group = new BranchGroup();
        world_object_group.addChild((Node)new ColorCube(2.0));
        AmbientLight light = new AmbientLight(new Color3f(1.0f, 1.0f, 1.0f));
        light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        world_object_group.addChild((Node)light);
        ViewPlatform viewplatform = new ViewPlatform();
        TransformGroup viewTransformGroup = new TransformGroup();
        viewTransformGroup.setCapability(18);
        viewTransformGroup.setCapability(17);
        Transform3D startPosition = new Transform3D();
        startPosition.setTranslation(new Vector3d(5.0, 0.0, 20.0));
        viewTransformGroup.setTransform(startPosition);
        viewTransformGroup.addChild((Node)viewplatform);
        world_object_group.addChild((Node)viewTransformGroup);
        DefaultMovementBehavior movementBehavior = new DefaultMovementBehavior();
        viewTransformGroup.addChild((Node)movementBehavior);
        movementBehavior.setTransformGroup(viewTransformGroup);
        InputDevice inputdevice = (InputDevice)this.config.getHelper().getComponent("InputDevice");
        inputdevice.initialize();
        this.env.addInputDevice(inputdevice);
        if (inputdevice instanceof HasBehavior) {
            viewTransformGroup.addChild((Node)((HasBehavior)inputdevice).getBehavior());
        }
        movementBehavior.setSensor(inputdevice.getSensor(0));
        locale.addBranchGraph(world_object_group);
        view.addCanvas3D(canvas3d);
        view.attachViewPlatform(viewplatform);
        JFrame window = new JFrame();
        window.getContentPane().add((Component)canvas3d);
        window.pack();
        window.validate();
        ((Component)window).setSize(new Dimension(400, 400));
        window.show();
    }

    public static void main(String[] args) {
        try {
            new InputTest(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

