/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.input;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import org.j3de.exception.ExceptionHandler;
import org.j3de.util.AbstractComponent;
import org.j3de.util.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JoystickInputDevice
extends AbstractComponent
implements InputDevice {
    private int[] BUTTONS = new int[0];
    private Sensor sensor = new Sensor((InputDevice)this);
    private int processingMode = 5;
    private Transform3D rotY;
    private Transform3D rotZ;
    private Transform3D transform;
    private Vector3d translation = new Vector3d();
    private int deviceNumber;
    private double turnAngle;
    private double error;
    private boolean ignoreZ;
    private Joystick joystick;

    public JoystickInputDevice() {
        this.transform = new Transform3D();
        this.rotY = new Transform3D();
        this.rotZ = new Transform3D();
    }

    public void close() {
    }

    public void configure(Node node, Document nodeFactory) throws ConfigurationException {
        super.configure(node, nodeFactory);
        this.turnAngle = Double.parseDouble(this.helper.getPropertyValue("TurnDegrees", "15", true)) / 360.0 * 2.0 * Math.PI;
        this.deviceNumber = this.helper.getPropertyValue("device", 0, true);
        this.ignoreZ = this.helper.getPropertyValue("ignoreZAxis", "true", true).equals("true");
        this.error = Double.parseDouble(this.helper.getPropertyValue("calibrationError", "0.0", true));
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public Sensor getSensor(int sensorIndex) {
        return this.sensor;
    }

    public int getSensorCount() {
        return 1;
    }

    public boolean initialize() {
        try {
            this.joystick = new Joystick(this.deviceNumber);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return false;
        }
    }

    public void pollAndProcessInput() {
        int buttons;
        double xpos = this.joystick.getXPos();
        double ypos = this.joystick.getYPos();
        double zpos = this.joystick.getZPos();
        if (Math.abs(xpos) > this.error) {
            this.transform.rotY(-1.0 * xpos * this.turnAngle);
        } else {
            this.transform.setIdentity();
        }
        if (Math.abs(ypos) > this.error) {
            this.rotY.rotX(ypos * this.turnAngle);
            this.transform.mul(this.rotY);
        }
        if (Math.abs(zpos) > this.error & (this.ignoreZ ^ true)) {
            this.rotZ.rotZ(zpos * this.turnAngle);
            this.transform.mul(this.rotZ);
        }
        this.translation.z = ((buttons = this.joystick.getButtons()) & 1) > 0 ? -1.0 : ((buttons & 2) > 0 ? 1.0 : 0.0);
        this.transform.setTranslation(this.translation);
        this.sensor.setNextSensorRead(System.currentTimeMillis(), this.transform, this.BUTTONS);
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int mode) {
        this.processingMode = mode;
    }
}

