/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.input;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.j3de.exception.ExceptionHandler;
import org.j3de.input.HasBehavior;
import org.j3de.input.KeyAction;
import org.j3de.util.AbstractComponent;
import org.j3de.util.ConfigurationException;
import org.j3de.util.EntryFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class KeyboardInputDevice
extends AbstractComponent
implements InputDevice,
HasBehavior {
    private static int[] BUTTONS = new int[0];
    private Sensor sensor = new Sensor((InputDevice)this);
    private int processingMode = 5;
    private Transform3D transform = new Transform3D();
    private Vector3f position = new Vector3f();
    private WakeupCondition keyCriterion;
    private Map actions;
    private Map keyAssignment = new Hashtable();
    private float currentSpeed = 1.0f;
    private float turnAngle;
    private Matrix3d transformX;
    private Matrix3d transformY;
    private Matrix3d transformZ;
    private Matrix3d result;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public KeyboardInputDevice() {
        this.position = new Vector3f();
        this.createActions();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() {
    }

    public void configure(Node node, Document nodeFactory) throws ConfigurationException {
        super.configure(node, nodeFactory);
        this.turnAngle = this.helper.getPropertyValue("TurnDegrees", 30, true);
        this.helper.getList("keyassignment", new EntryFactory(){

            public Object createEntry(Node node) {
                try {
                    NamedNodeMap attributes = node.getAttributes();
                    String name = attributes.getNamedItem("name").getNodeValue();
                    String value = attributes.getNamedItem("value").getNodeValue();
                    Integer keyvalue = (Integer)(class$java$awt$event$KeyEvent != null ? class$java$awt$event$KeyEvent : (class$java$awt$event$KeyEvent = KeyboardInputDevice.class$("java.awt.event.KeyEvent"))).getDeclaredField("VK_" + name).get(null);
                    Object keyaction = KeyboardInputDevice.this.actions.get(value);
                    KeyboardInputDevice.this.keyAssignment.put(keyvalue, keyaction);
                    return null;
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                    return null;
                }
            }
        });
    }

    public synchronized void createActions() {
        this.actions = new Hashtable();
        this.actions.put("move_forward", new MoveKeyAction(2, -1.0f));
        this.actions.put("move_backward", new MoveKeyAction(2, 1.0f));
        this.actions.put("move_left", new MoveKeyAction(0, -1.0f));
        this.actions.put("move_right", new MoveKeyAction(0, 1.0f));
        this.actions.put("move_up", new MoveKeyAction(1, 1.0f));
        this.actions.put("move_down", new MoveKeyAction(1, -1.0f));
        this.actions.put("roll_right", new TurnKeyAction(2, 1.0));
        this.actions.put("roll_left", new TurnKeyAction(2, -1.0));
        this.actions.put("turn_left", new TurnKeyAction(1, -1.0));
        this.actions.put("turn_right", new TurnKeyAction(1, 1.0));
        this.actions.put("turn_up", new TurnKeyAction(0, -1.0));
        this.actions.put("turn_down", new TurnKeyAction(0, 1.0));
        this.actions.put("speed_up", new SpeedKeyAction(2.0f));
        this.actions.put("speed_down", new SpeedKeyAction(0.5f));
    }

    public Behavior getBehavior() {
        return new Behavior(){

            public void initialize() {
                this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
                WakeupCriterion[] keyEvents = new WakeupCriterion[]{new WakeupOnAWTEvent(401), new WakeupOnAWTEvent(402)};
                KeyboardInputDevice.this.keyCriterion = (WakeupCondition)new WakeupOr(keyEvents);
                this.wakeupOn(KeyboardInputDevice.this.keyCriterion);
            }

            public synchronized void processStimulus(Enumeration criteria) {
                while (criteria.hasMoreElements()) {
                    WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
                    if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
                    AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                    int i = 0;
                    while (i < event.length) {
                        if (event[i].getID() == 401 || event[i].getID() == 402) {
                            KeyboardInputDevice.this.processKeyEvent((KeyEvent)event[i]);
                        }
                        ++i;
                    }
                }
                this.wakeupOn(KeyboardInputDevice.this.keyCriterion);
            }
        };
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public Sensor getSensor(int sensorIndex) {
        return this.sensor;
    }

    public int getSensorCount() {
        return 1;
    }

    public boolean initialize() {
        return true;
    }

    public void pollAndProcessInput() {
        this.sensor.setNextSensorRead(System.currentTimeMillis(), this.transform, BUTTONS);
    }

    private void processKeyEvent(KeyEvent event) {
        Integer key = new Integer(event.getKeyCode());
        KeyAction action = (KeyAction)this.keyAssignment.get(key);
        if (action != null) {
            if (event.getID() == 401) {
                action.keyPressed();
            } else if (event.getID() == 402) {
                action.keyReleased();
            }
        }
    }

    public synchronized void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int mode) {
        this.processingMode = mode;
    }

    private class MoveKeyAction
    implements KeyAction {
        int index;
        float faktor;

        public MoveKeyAction(int index, float faktor) {
            this.index = index;
            this.faktor = faktor;
        }

        public void keyPressed() {
            if (this.index == 0) {
                ((KeyboardInputDevice)KeyboardInputDevice.this).position.x = KeyboardInputDevice.this.currentSpeed * this.faktor;
            } else if (this.index == 1) {
                ((KeyboardInputDevice)KeyboardInputDevice.this).position.y = KeyboardInputDevice.this.currentSpeed * this.faktor;
            } else if (this.index == 2) {
                ((KeyboardInputDevice)KeyboardInputDevice.this).position.z = KeyboardInputDevice.this.currentSpeed * this.faktor;
            }
            KeyboardInputDevice.this.transform.set(KeyboardInputDevice.this.position);
        }

        public void keyReleased() {
            if (this.index == 0) {
                ((KeyboardInputDevice)KeyboardInputDevice.this).position.x = 0.0f;
            } else if (this.index == 1) {
                ((KeyboardInputDevice)KeyboardInputDevice.this).position.y = 0.0f;
            } else if (this.index == 2) {
                ((KeyboardInputDevice)KeyboardInputDevice.this).position.z = 0.0f;
            }
            KeyboardInputDevice.this.transform.set(KeyboardInputDevice.this.position);
        }
    }

    private class TurnKeyAction
    implements KeyAction {
        private int index;
        private double direction;

        public TurnKeyAction(int index, double direction) {
            this.index = index;
            this.direction = direction;
            KeyboardInputDevice.this.transformX = new Matrix3d();
            KeyboardInputDevice.this.transformX.setIdentity();
            KeyboardInputDevice.this.transformY = new Matrix3d();
            KeyboardInputDevice.this.transformY.setIdentity();
            KeyboardInputDevice.this.transformZ = new Matrix3d();
            KeyboardInputDevice.this.transformZ.setIdentity();
            KeyboardInputDevice.this.result = new Matrix3d();
        }

        public void keyPressed() {
            if (this.index == 0) {
                KeyboardInputDevice.this.transformX.rotX((double)KeyboardInputDevice.this.turnAngle * this.direction);
            } else if (this.index == 1) {
                KeyboardInputDevice.this.transformY.rotY((double)KeyboardInputDevice.this.turnAngle * this.direction);
            } else if (this.index == 2) {
                KeyboardInputDevice.this.transformZ.rotZ((double)KeyboardInputDevice.this.turnAngle * this.direction);
            }
            this.updateTransform();
        }

        public void keyReleased() {
            if (this.index == 0) {
                KeyboardInputDevice.this.transformX.setIdentity();
            } else if (this.index == 1) {
                KeyboardInputDevice.this.transformY.setIdentity();
            } else if (this.index == 2) {
                KeyboardInputDevice.this.transformZ.setIdentity();
            }
            this.updateTransform();
        }

        private void updateTransform() {
            KeyboardInputDevice.this.result.setIdentity();
            KeyboardInputDevice.this.result.mul(KeyboardInputDevice.this.transformX);
            KeyboardInputDevice.this.result.mul(KeyboardInputDevice.this.transformY);
            KeyboardInputDevice.this.result.mul(KeyboardInputDevice.this.transformZ);
            KeyboardInputDevice.this.transform.set(KeyboardInputDevice.this.result);
        }
    }

    private class SpeedKeyAction
    implements KeyAction {
        private float faktor;

        public SpeedKeyAction(float faktor) {
            this.faktor = faktor;
        }

        public void keyPressed() {
            KeyboardInputDevice keyboardInputDevice = KeyboardInputDevice.this;
            keyboardInputDevice.currentSpeed = keyboardInputDevice.currentSpeed * this.faktor;
        }

        public void keyReleased() {
            KeyboardInputDevice keyboardInputDevice = KeyboardInputDevice.this;
            keyboardInputDevice.currentSpeed = keyboardInputDevice.currentSpeed / this.faktor;
        }
    }
}

