/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.input;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.j3de.input.HasBehavior;
import org.j3de.util.AbstractComponent;
import org.j3de.util.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MouseInputDevice
extends AbstractComponent
implements InputDevice,
HasBehavior {
    private static int[] BUTTONS = new int[1];
    private Sensor sensor = new Sensor((InputDevice)this, 30, 1);
    private int processingMode;
    private Transform3D transform;
    private Vector3d currentPosition;
    private double maxXAmplitude;
    private double maxYAmplitude;
    private double maxZAmplitude;
    private double movementSpeed;
    private double screenX;
    private double screenY;
    private long leftButtonDownTime;
    private long middleButtonDownTime;
    private long rightButtonDownTime;
    private WakeupCondition mouseCriterion;

    public MouseInputDevice() {
        this.sensor.setPredictionPolicy(16);
        this.processingMode = 5;
    }

    public void close() {
    }

    public void configure(Node node, Document nodeFactory) throws ConfigurationException {
        super.configure(node, nodeFactory);
        this.maxXAmplitude = Double.parseDouble(this.helper.getPropertyValue("maxXAmplitude", "10", true));
        this.maxYAmplitude = Double.parseDouble(this.helper.getPropertyValue("maxYAmplitude", "10", true));
        this.maxZAmplitude = Double.parseDouble(this.helper.getPropertyValue("maxZAmplitude", "10", true));
        this.movementSpeed = Double.parseDouble(this.helper.getPropertyValue("speed", "10", true));
    }

    public Behavior getBehavior() {
        return new Behavior(){

            public void initialize() {
                this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
                WakeupCriterion[] mouseEvents = new WakeupCriterion[]{new WakeupOnAWTEvent(503), new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(502), new WakeupOnAWTEvent(506)};
                MouseInputDevice.this.mouseCriterion = (WakeupCondition)new WakeupOr(mouseEvents);
                this.wakeupOn(MouseInputDevice.this.mouseCriterion);
            }

            public synchronized void processStimulus(Enumeration criteria) {
                while (criteria.hasMoreElements()) {
                    WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
                    if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
                    AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                    int i = 0;
                    while (i < event.length) {
                        if (event[i].getID() == 503 || event[i].getID() == 501 || event[i].getID() == 502 || event[i].getID() == 506) {
                            MouseInputDevice.this.processMouseEvent((MouseEvent)event[i]);
                        } else {
                            System.out.println("Unknown event : " + event);
                        }
                        ++i;
                    }
                }
                this.wakeupOn(MouseInputDevice.this.mouseCriterion);
            }
        };
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public Sensor getSensor(int sensorIndex) {
        return this.sensor;
    }

    public int getSensorCount() {
        return 1;
    }

    public boolean initialize() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenX = d.getWidth() / 2.0;
        this.screenY = d.getHeight() / 2.0;
        this.transform = new Transform3D();
        this.currentPosition = new Vector3d();
        return true;
    }

    public synchronized void pollAndProcessInput() {
        MouseInputDevice.BUTTONS[0] = this.leftButtonDownTime == 0L ? 0 : 1;
        long currentTime = System.currentTimeMillis();
        if (this.middleButtonDownTime != 0L) {
            this.currentPosition.z -= (double)(currentTime - this.middleButtonDownTime) / 1000.0 * this.movementSpeed;
            this.middleButtonDownTime = currentTime;
        }
        if (this.rightButtonDownTime != 0L) {
            this.currentPosition.z += (double)(currentTime - this.rightButtonDownTime) / 1000.0 * this.movementSpeed;
            this.rightButtonDownTime = currentTime;
        }
        if (this.currentPosition.z > this.maxZAmplitude) {
            this.currentPosition.z = this.maxZAmplitude;
        }
        if (this.currentPosition.z < -this.maxZAmplitude) {
            this.currentPosition.z = -this.maxZAmplitude;
        }
        this.transform.setTranslation(this.currentPosition);
        this.sensor.setNextSensorRead(currentTime, this.transform, BUTTONS);
    }

    private synchronized void processMouseEvent(MouseEvent event) {
        if (event == null) {
            return;
        }
        if (event.getID() == 503 || event.getID() == 506) {
            this.currentPosition.x = ((double)event.getX() - this.screenX) / this.screenX * this.maxXAmplitude;
            this.currentPosition.y = -((double)event.getY() - this.screenY) / this.screenY * this.maxYAmplitude;
        } else if (event.getID() == 501) {
            if ((event.getModifiers() & 0x10) > 0 && this.leftButtonDownTime == 0L) {
                this.leftButtonDownTime = event.getWhen();
            }
            if ((event.getModifiers() & 8) > 0 && this.middleButtonDownTime == 0L) {
                this.middleButtonDownTime = event.getWhen();
            }
            if ((event.getModifiers() & 4) > 0 && this.rightButtonDownTime == 0L) {
                this.rightButtonDownTime = event.getWhen();
            }
        } else if (event.getID() == 502) {
            if ((event.getModifiers() & 0x10) > 0 && this.leftButtonDownTime != 0L) {
                this.leftButtonDownTime = 0L;
            }
            if ((event.getModifiers() & 8) > 0 && this.middleButtonDownTime != 0L) {
                this.currentPosition.z -= (double)(event.getWhen() - this.middleButtonDownTime) / 1000.0 * this.movementSpeed;
                this.middleButtonDownTime = 0L;
            }
            if ((event.getModifiers() & 4) > 0 && this.rightButtonDownTime != 0L) {
                this.currentPosition.z += (double)(event.getWhen() - this.rightButtonDownTime) / 1000.0 * this.movementSpeed;
                this.rightButtonDownTime = 0L;
            }
        }
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int mode) {
        this.processingMode = mode;
    }
}

