/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.input;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import org.j3de.input.ActivationListener;
import org.j3de.input.ActivationManager;

public class VirtualInputDevice
implements InputDevice {
    private Sensor[] sensors;
    private InputDevice device;
    private boolean isActive = true;

    public VirtualInputDevice(InputDevice device, ActivationManager manager) {
        this.device = device;
        this.sensors = new Sensor[device.getSensorCount()];
        int i = 0;
        while (i < device.getSensorCount()) {
            this.sensors[i] = new VirtualSensor(device.getSensor(i));
            ++i;
        }
        manager.addActivationListener(new ActivationListener(){

            public void setActivation(boolean isActive) {
                VirtualInputDevice.this.isActive = isActive;
            }
        });
    }

    public void close() {
    }

    public int getProcessingMode() {
        return this.device.getProcessingMode();
    }

    public Sensor getSensor(int sensorIndex) {
        return this.sensors[sensorIndex];
    }

    public int getSensorCount() {
        return this.sensors.length;
    }

    public boolean initialize() {
        return true;
    }

    public void pollAndProcessInput() {
        if (this.isActive) {
            this.device.pollAndProcessInput();
        }
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int mode) {
    }

    private class VirtualSensor
    extends Sensor {
        private Sensor originalSensor;
        private long lasttime;

        public VirtualSensor(Sensor originalSensor) {
            super((InputDevice)VirtualInputDevice.this, originalSensor.getSensorReadCount(), originalSensor.getSensorButtonCount());
            this.originalSensor = originalSensor;
            this.lasttime = 0L;
        }

        public SensorRead getCurrentSensorRead() {
            if (VirtualInputDevice.this.isActive) {
                return this.originalSensor.getCurrentSensorRead();
            }
            return new SensorRead(this.getSensorButtonCount());
        }

        public InputDevice getDevice() {
            return VirtualInputDevice.this;
        }

        public void getHotspot(Point3d hotspot) {
            this.originalSensor.getHotspot(hotspot);
        }

        public int getPredictionPolicy() {
            return this.originalSensor.getPredictionPolicy();
        }

        public int getPredictor() {
            return this.originalSensor.getPredictor();
        }

        public void getRead(Transform3D read) {
            if (VirtualInputDevice.this.isActive) {
                this.originalSensor.getRead(read);
            } else {
                read.setIdentity();
            }
        }

        public void getRead(Transform3D read, long deltaT) {
            if (VirtualInputDevice.this.isActive) {
                this.originalSensor.getRead(read, deltaT);
            } else {
                read.setIdentity();
            }
        }

        public void lastButtons(int k, int[] values) {
            if (VirtualInputDevice.this.isActive) {
                this.originalSensor.lastButtons(k, values);
            }
        }

        public void lastButtons(int[] values) {
            if (VirtualInputDevice.this.isActive) {
                this.originalSensor.lastButtons(values);
            }
        }

        public void lastRead(Transform3D read) {
            if (VirtualInputDevice.this.isActive) {
                this.originalSensor.lastRead(read);
            } else {
                read.setIdentity();
            }
        }

        public void lastRead(Transform3D read, int kth) {
            if (VirtualInputDevice.this.isActive) {
                this.originalSensor.lastRead(read, kth);
            } else {
                read.setIdentity();
            }
        }

        public long lastTime() {
            if (VirtualInputDevice.this.isActive) {
                this.lasttime = this.originalSensor.lastTime();
            }
            return this.lasttime;
        }

        public long lastTime(int k) {
            if (VirtualInputDevice.this.isActive) {
                this.lasttime = this.originalSensor.lastTime(k);
            }
            return this.lasttime;
        }
    }
}

