/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.j3de.exception.ExceptionHandler;
import org.j3de.util.Configurable;
import org.j3de.util.ConfigurationException;
import org.j3de.util.EntryFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigHelper {
    private Node root;
    private Document nodeFactory;
    private List components;
    private boolean configurationChanged;

    public ConfigHelper(Node root) {
        this(root, null, false);
    }

    public ConfigHelper(Node root, Document nodeFactory, boolean newNode) {
        this.root = root;
        this.nodeFactory = nodeFactory;
        this.components = new Vector();
        this.configurationChanged = newNode;
    }

    public void configurationSaved() {
        this.configurationChanged = false;
        int i = 0;
        while (i < this.components.size()) {
            if (((Configurable)this.components.get(i)).isConfigurationChanged()) {
                ((Configurable)this.components.get(i)).configurationSaved();
            }
            ++i;
        }
    }

    public Object getComponent(String componentName) throws ConfigurationException {
        return this.getComponent(componentName, null, null, null);
    }

    public Object getComponent(String componentName, Class defaultImplementation) throws ConfigurationException {
        return this.getComponent(componentName, defaultImplementation, null, null);
    }

    public Object getComponent(String componentName, Class defaultImplementation, Class[] parameterTypes, Object[] parameters) throws ConfigurationException {
        return this.getComponent(componentName, defaultImplementation, parameterTypes, parameters, this.getClass().getClassLoader());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object getComponent(String componentName, Class defaultImplementation, Class[] parameterTypes, Object[] parameters, ClassLoader loader) throws ConfigurationException {
        classname = null;
        try {
            result /* !! */  = null;
            nodes = this.root.getChildNodes();
            i = 0;
            while (i < nodes.getLength()) {
                node = nodes.item(i);
                if (node.getNodeName().equals("component")) {
                    name = null;
                    attributes = node.getAttributes();
                    attrnr = 0;
                    while (attrnr < attributes.getLength()) {
                        attrname = attributes.item(attrnr).getNodeName();
                        if (attrname.equals("name")) {
                            name = attributes.item(attrnr).getNodeValue();
                        } else if (attrname.equals("classname")) {
                            classname = attributes.item(attrnr).getNodeValue();
                        }
                        ++attrnr;
                    }
                    if (classname != null && (componentName == null || name != null && name.equals(componentName))) {
                        if (parameterTypes != null) {
                            block25: {
                                try {
                                    constructor = loader.loadClass(classname.trim()).getConstructor(parameterTypes);
                                    break block25;
                                }
                                catch (NoSuchMethodException e) {
                                    ExceptionHandler.handleException(e);
                                    parameterString = "(";
                                    j = 0;
                                    ** while (j < parameterTypes.length)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    parameterString = String.valueOf(parameterString) + parameterTypes[j].getName() + " ";
                                    ++j;
                                    continue;
                                }
lbl34:
                                // 1 sources

                                parameterString = String.valueOf(parameterString) + ")";
                                throw new ConfigurationException("Class " + classname + " has no constructor" + parameterString);
                            }
                            result /* !! */  = constructor.newInstance(parameters);
                        } else {
                            result /* !! */  = loader.loadClass(classname.trim()).newInstance();
                        }
                    }
                    if (result /* !! */  instanceof Configurable) {
                        result /* !! */ .configure(node, this.nodeFactory);
                    }
                }
                ++i;
            }
            if (result /* !! */  == null && defaultImplementation != null) {
                this.configurationChanged = true;
                if (parameterTypes != null) {
                    block26: {
                        try {
                            constructor = defaultImplementation.getConstructor(parameterTypes);
                            break block26;
                        }
                        catch (NoSuchMethodException e) {
                            ExceptionHandler.handleException(e);
                            parameterString = "(";
                            j = 0;
                            ** while (j < parameterTypes.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            parameterString = String.valueOf(parameterString) + parameterTypes[j].getName() + " ";
                            ++j;
                            continue;
                        }
lbl58:
                        // 1 sources

                        parameterString = String.valueOf(parameterString) + ")";
                        throw new ConfigurationException("Class " + defaultImplementation + " has no constructor" + parameterString);
                    }
                    result /* !! */  = (Configurable)constructor.newInstance(parameters);
                } else {
                    result /* !! */  = (Configurable)defaultImplementation.newInstance();
                }
                this.root.appendChild(result /* !! */ .configure(this.nodeFactory, componentName));
            }
            if (result /* !! */  != null && result /* !! */  instanceof Configurable) {
                this.components.add(result /* !! */ );
            }
            return result /* !! */ ;
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e);
            throw new ConfigurationException("Class " + classname + " could not be found while loading component : " + componentName);
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.handleException(e);
            throw new ConfigurationException("No access to constructor of class " + classname + " while loading component : " + componentName);
        }
        catch (InstantiationException e) {
            ExceptionHandler.handleException(e);
            throw new ConfigurationException("Exception while instantiating  " + classname + " while loading component : " + componentName);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handleException(e);
            throw new ConfigurationException("Exception thrown by constructor of class  " + classname + " while loading component : " + componentName);
        }
    }

    public List getComponentList(String name) {
        return this.getList(name, new ComponentFactory());
    }

    public Map getComponentMap(String name) {
        return this.getMap(name, new ComponentFactory());
    }

    public Map getComponentMap(String name, ClassLoader loader) {
        return this.getMap(name, new ComponentFactory(loader));
    }

    public List getIntList(String name) {
        return this.getList(name, new EntryFactory(){

            public Object createEntry(Node node) {
                try {
                    NamedNodeMap attributes = node.getAttributes();
                    return new Integer(attributes.getNamedItem("name").getNodeValue());
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                    return null;
                }
            }
        });
    }

    public List getList(String name, EntryFactory factory) {
        Vector<Object> result = new Vector<Object>();
        NodeList childNodes = this.root.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            NamedNodeMap attributes;
            Node attrib;
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("list") && (attrib = (attributes = node.getAttributes()).getNamedItem("name")) != null && attrib.getNodeValue().equals(name)) {
                NodeList itemList = node.getChildNodes();
                int j = 0;
                while (j < itemList.getLength()) {
                    Node item = itemList.item(j);
                    if (item.getNodeName().equals("listitem")) {
                        try {
                            result.add(factory.createEntry(item));
                        }
                        catch (Exception exception) {
                            ExceptionHandler.handleException(new ConfigurationException("Got null-value for map. Skipping Entry."));
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public Map getMap(String name, EntryFactory factory) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        NodeList childNodes = this.root.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            NamedNodeMap attributes;
            Node attrib;
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("map") && (attrib = (attributes = node.getAttributes()).getNamedItem("name")) != null && attrib.getNodeValue().equals(name)) {
                NodeList itemList = node.getChildNodes();
                int j = 0;
                while (j < itemList.getLength()) {
                    Node item = itemList.item(j);
                    if (item.getNodeName().equals("mapitem")) {
                        NamedNodeMap itemattributes = item.getAttributes();
                        Node itemname = itemattributes.getNamedItem("name");
                        try {
                            result.put(itemname.getNodeValue(), factory.createEntry(item));
                        }
                        catch (NullPointerException e) {
                            ExceptionHandler.handleException(e);
                            ExceptionHandler.handleException(new ConfigurationException("Got null-value for map. Skipping Entry."));
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public String getPropertyValue(String name) {
        NodeList childNodes = this.root.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            NamedNodeMap attributes;
            Node attrib;
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("property") && (attrib = (attributes = node.getAttributes()).getNamedItem("name")) != null && attrib.getNodeValue().equals(name)) {
                return attributes.getNamedItem("value").getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public double getPropertyValue(String name, double defaultValue, boolean warn) {
        return Double.parseDouble(this.getPropertyValue(name, new Double(defaultValue).toString(), warn));
    }

    public int getPropertyValue(String name, int defaultValue, boolean warn) {
        return Integer.parseInt(this.getPropertyValue(name, new Integer(defaultValue).toString(), warn));
    }

    public String getPropertyValue(String name, String defaultValue, boolean warn) {
        String value = this.getPropertyValue(name);
        if (value != null) {
            return value;
        }
        if (warn) {
            ExceptionHandler.handleWarning("Property not found : " + name + " in Node " + this.root.getNodeName() + " [" + this.root.getNodeValue() + "]");
        }
        return defaultValue;
    }

    public Map getStringMap(String name) {
        return this.getMap(name, new EntryFactory(){

            public Object createEntry(Node node) {
                try {
                    NamedNodeMap attributes = node.getAttributes();
                    return attributes.getNamedItem("value").getNodeValue();
                }
                catch (Exception e) {
                    ExceptionHandler.handleException(e);
                    return null;
                }
            }
        });
    }

    public boolean isConfigurationChanged() {
        if (this.configurationChanged) {
            return true;
        }
        int i = 0;
        while (i < this.components.size()) {
            if (((Configurable)this.components.get(i)).isConfigurationChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Element newComponent(Document nodeFactory, String componentKind, Configurable component) {
        Element element = nodeFactory.createElement("component");
        element.setAttribute("name", componentKind);
        element.setAttribute("classname", component.getClass().getName());
        return element;
    }

    public void newProperty(String name, String value) {
        this.configurationChanged = true;
        Element element = this.nodeFactory.createElement("property");
        element.setAttribute("name", name);
        element.setAttribute("value", value);
        this.root.appendChild(element);
    }

    private class ComponentFactory
    implements EntryFactory {
        private ClassLoader classloader;

        public ComponentFactory() {
            this.classloader = this.getClass().getClassLoader();
        }

        public ComponentFactory(ClassLoader classloader) {
            this.classloader = classloader;
        }

        public Object createEntry(Node node) {
            try {
                return new ConfigHelper(node, ConfigHelper.this.nodeFactory, false).getComponent(null, null, null, null, this.classloader);
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
                return null;
            }
        }
    }
}

