/*
 * Decompiled with CFR 0.152.
 */
package org.j3de.util;

import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.j3de.util.ConfigHelper;
import org.j3de.util.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configuration {
    private XmlDocument configDocument;
    private Element rootElement;
    private ConfigHelper configHelper;

    public Configuration() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.configDocument = (XmlDocument)builder.newDocument();
        this.rootElement = this.configDocument.createElement("configuration");
        this.rootElement.setAttribute("name", "j3de");
        this.configHelper = new ConfigHelper(this.rootElement, (Document)this.configDocument, true);
        this.configDocument.appendChild((Node)this.rootElement);
    }

    public Configuration(Reader reader) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.configDocument = (XmlDocument)builder.parse(new InputSource(reader));
        this.rootElement = this.configDocument.getDocumentElement();
        this.configHelper = new ConfigHelper(this.rootElement, (Document)this.configDocument, false);
    }

    public Configuration(String filename) throws IOException, ParserConfigurationException, SAXException {
        this(new FileReader(new File(filename)));
    }

    public Configuration(URL url) throws IOException, ParserConfigurationException, SAXException {
        this(new InputStreamReader(url.openStream()));
    }

    public Object getComponent(String componentName, Class defaultImplementation) throws ConfigurationException {
        return this.getComponent(componentName, defaultImplementation, null, null);
    }

    public Object getComponent(String componentName, Class defaultImplementation, Class[] parameterTypes, Object[] parameters) throws ConfigurationException {
        return this.configHelper.getComponent(componentName, defaultImplementation, parameterTypes, parameters);
    }

    public Object getComponent(String componentName, ClassLoader loader) throws ConfigurationException {
        return this.configHelper.getComponent(componentName, null, null, null, loader);
    }

    public ConfigHelper getHelper() {
        return this.configHelper;
    }

    public String getProperty(String name) {
        return this.configHelper.getPropertyValue(name);
    }

    public String getProperty(String name, String defaultValue, boolean warn) {
        return this.configHelper.getPropertyValue(name, defaultValue, warn);
    }

    public boolean isConfigurationChanged() {
        return this.configHelper.isConfigurationChanged();
    }

    public void saveConfiguration(String filename) throws IOException {
        this.configDocument.write((Writer)new FileWriter(new File(filename)));
        this.configHelper.configurationSaved();
    }
}

