package org.j3de.exception;         

import java.lang.reflect.InvocationTargetException;

import javax.swing.SwingUtilities;
import javax.swing.JOptionPane;

public class DefaultExceptionHandler extends ExceptionHandler {

  protected void handleExceptionImpl(final Exception e) {
    Runnable showException = new Runnable() {
      public void run() {                                   
        e.printStackTrace();
        JOptionPane.showMessageDialog(null, e, e.getMessage(), JOptionPane.ERROR_MESSAGE);
      }
    };

    SwingUtilities.invokeLater(showException);
  }

  protected void handleFatalExceptionImpl(final Exception e) {
    Runnable showException = new Runnable() {
      public void run() {                                   
        e.printStackTrace();
        JOptionPane.showMessageDialog(null, e, e.getMessage(), JOptionPane.ERROR_MESSAGE);    
      }
    };
   
    try {
      SwingUtilities.invokeAndWait(showException);      
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    } catch (InvocationTargetException ex) {
      ex.printStackTrace();
    }
  }  
  
  protected void handleWarningImpl(final String msg) {
    Runnable showException = new Runnable() {
      public void run() {                                   
        JOptionPane.showMessageDialog(null, msg, "Warning", JOptionPane.WARNING_MESSAGE);    
      }
    };

    SwingUtilities.invokeLater(showException);
  }


}
