package org.j3de.exception;

import org.j3de.permission.ExceptionHandlerPermission;

public abstract class ExceptionHandler {
  public static boolean SHOW_WARNING = true;
  public static boolean HIDE_WARNING = false;
  private static ExceptionHandler exceptionHandler = null;

  public ExceptionHandler() {
    SecurityManager sm = System.getSecurityManager();
    if (sm != null) {
       sm.checkPermission(new ExceptionHandlerPermission("instantiate"));
    }

    exceptionHandler = this;
  }

  protected abstract void handleExceptionImpl(Exception e);

  public static void handleException(Exception e) {
    if (exceptionHandler == null)
      exceptionHandler = new DefaultExceptionHandler();

    exceptionHandler.handleExceptionImpl(e);
  }

  protected abstract void handleFatalExceptionImpl(Exception e);

  public static void handleFatalException(Exception e) {
    if (exceptionHandler == null)
      exceptionHandler = new DefaultExceptionHandler();

    exceptionHandler.handleFatalExceptionImpl(e);
  }      
  
  protected abstract void handleWarningImpl(String msg);

  public static void handleWarning(String msg) {
    if (exceptionHandler == null)
      exceptionHandler = new DefaultExceptionHandler();

    exceptionHandler.handleWarningImpl(msg);    
  }

}
